/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.restlet.Client;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.FileRepresentation;
import org.restlet.resource.OutputRepresentation;
import org.restlet.resource.Representation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApplicationTest {
    public static final String DCDPP_MACHINE_IP = "IP";
    public static final String DCDPP_MACHINE_PORT = "PORT";
    public static final String DCDPP_MACHINE_ID = "ID";
    public static final String FILE_TYPE_PARM_VAR = "ftype";
    public static final String FILE_Name_PARM_VAR = "fname";
    public static final String FILE_CLASS_PARM_VAR = "class";
    public static final String FILE_MA_TYPE_VAR = "ma";
    public static final String FILE_EVENT_TYPE_VAR = "ev";
    public static final String FILE_SUPPORT_TYPE_VAR = "sup";
    public static final String FILE_SRC_TYPE_VAR = "src";
    public static final String FILE_HDR_TYPE_VAR = "hdr";
    static String loginUsername = null;
    static String loginPassword = null;
    public static final String APPLICATION_URI = "http://134.117.62.118:8080/cdpp";

    public static void main(String ... args) throws Exception {
        System.out.println("Server Base URI: http://134.117.62.118:8080/cdpp");
        System.out.println();
        if (args.length > 0) {
            if (args[0].equals("PutAccount")) {
                if (args.length == 6) {
                    ApplicationTest.PutAccount(args[1], args[2], args[3], args[4], Boolean.valueOf(args[5]));
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("Options")) {
                ApplicationTest.Options();
            } else if (args[0].equals("DeleteAccount")) {
                if (args.length == 4) {
                    ApplicationTest.DeleteAccount(args[1], args[2], args[3]);
                }
            } else if (args[0].equals("PutWorkspace")) {
                if (args.length == 5) {
                    ApplicationTest.PutWorkspace(args[1], args[2], args[3], Boolean.valueOf(args[4]));
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("PutService")) {
                if (args.length == 5) {
                    ApplicationTest.PutService(args[1], args[2], args[3], Boolean.valueOf(args[4]));
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("PutFramework")) {
                if (args.length == 4) {
                    ApplicationTest.PutFramework(args[1], args[2], args[3]);
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("GetResults")) {
                if (args.length == 4) {
                    ApplicationTest.GetResults(args[1], args[2], args[3]);
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("PutXMLFile")) {
                if (args.length == 5) {
                    ApplicationTest.PutXMLFile(args[1], args[2], args[3], args[4]);
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("PostTextFile")) {
                if (args.length == 6) {
                    ApplicationTest.PostTextFile(args[1], args[2], args[3], args[4], args[5]);
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("PostZipFile")) {
                if (args.length == 5) {
                    ApplicationTest.PostZipFile(args[1], args[2], args[3], args[4]);
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("PutServerConfig")) {
                if (args.length == 4) {
                    ApplicationTest.PutServerConfig(args[1], args[2], args[3]);
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("DeleteWorkspace")) {
                if (args.length == 4) {
                    ApplicationTest.DeleteWorkspace(args[1], args[2], args[3]);
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("DeleteService")) {
                if (args.length == 4) {
                    ApplicationTest.DeleteService(args[1], args[2], args[3]);
                } else {
                    System.out.println("Check args...");
                }
            } else if (args[0].equals("DeleteFramework")) {
                if (args.length == 4) {
                    ApplicationTest.DeleteFramework(args[1], args[2], args[3]);
                } else {
                    System.out.println("Check args...");
                }
            } else {
                System.out.println("Unknown Test method");
            }
        }
    }

    public static Request getAuthenticatedRequest(Method method, String uri, String login, String password) {
        Request request = new Request(method, uri);
        request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, login, password));
        return request;
    }

    public static void Options() throws IOException {
        String uri = APPLICATION_URI;
        Response response = new Client(Protocol.HTTP).options(uri);
        System.out.println(response.getStatus());
        if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
            ApplicationTest.writeRepresentation(response.getEntity(), "CDpp.wadl");
        }
    }

    public static void GetResults(String loginUsername, String loginPassword, String frameworkName) {
        String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + frameworkName + "/results";
        Request request = ApplicationTest.getAuthenticatedRequest(Method.GET, uri, loginUsername, loginPassword);
        Response response = new Client(Protocol.HTTP).handle(request);
        if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
            ApplicationTest.writeRepresentation(response.getEntity(), "results.zip");
        }
        System.out.println(response.getStatus());
    }

    public static void PutAccount(String loginUsername, String loginPassword, String AccountName, String AccountPassword, boolean isAdmin) {
        try {
            DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
            Document d = representation.getDocument();
            Element root = d.createElement("Account");
            d.appendChild(root);
            Element eltPassword = d.createElement("Password");
            eltPassword.appendChild(d.createTextNode(AccountPassword));
            root.appendChild(eltPassword);
            Element eltAdmin = d.createElement("Admin");
            eltAdmin.appendChild(d.createTextNode(Boolean.toString(isAdmin)));
            root.appendChild(eltAdmin);
            d.normalizeDocument();
            String uri = "http://134.117.62.118:8080/cdpp/admin/accounts/" + AccountName;
            Request request = ApplicationTest.getAuthenticatedRequest(Method.PUT, uri, loginUsername, loginPassword);
            request.setEntity((Representation)representation);
            Response resp = new Client(Protocol.HTTP).handle(request);
            System.out.println(resp.getStatus());
            System.out.println(resp.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void PutServerConfig(String loginUsername, String loginPassword, String password) {
        try {
            DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
            Document d = representation.getDocument();
            Element root = d.createElement("ServerConfig");
            d.appendChild(root);
            Element PasswordElm = d.createElement("Password");
            PasswordElm.appendChild(d.createTextNode(password));
            root.appendChild(PasswordElm);
            d.normalizeDocument();
            String uri = "http://134.117.62.118:8080/cdpp/admin/config/";
            Request request = ApplicationTest.getAuthenticatedRequest(Method.PUT, uri, loginUsername, loginPassword);
            request.setEntity((Representation)representation);
            Response resp = new Client(Protocol.HTTP).handle(request);
            System.out.println(resp.getStatus());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void PutService(String loginUsername, String loginPassword, String ServiceName, boolean restricted) {
        try {
            DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
            Document d = representation.getDocument();
            Element root = d.createElement("ConfigService");
            d.appendChild(root);
            Element RestrictedElm = d.createElement("Restricted");
            RestrictedElm.appendChild(d.createTextNode(Boolean.toString(restricted)));
            root.appendChild(RestrictedElm);
            d.normalizeDocument();
            String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + ServiceName;
            Request request = ApplicationTest.getAuthenticatedRequest(Method.PUT, uri, loginUsername, loginPassword);
            request.setEntity((Representation)representation);
            Response resp = new Client(Protocol.HTTP).handle(request);
            System.out.println(resp.getStatus());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir") + System.getProperty("file.separator");
    }

    public static void PostTextFile(String loginUsername, String loginPassword, String frameworkName, String filename, String vars) {
        FileRepresentation outfile = new FileRepresentation(ApplicationTest.getCurrentDir() + filename, MediaType.TEXT_PLAIN);
        String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + frameworkName;
        if (vars != null) {
            uri = uri + vars;
        }
        Request request = ApplicationTest.getAuthenticatedRequest(Method.POST, uri, loginUsername, loginPassword);
        request.setEntity((Representation)outfile);
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus());
    }

    public static void PutXMLFile(String loginUsername, String loginPassword, String frameworkName, String filename) {
        File file = new File(ApplicationTest.getCurrentDir() + filename);
        if (file.exists()) {
            FileRepresentation outfile = new FileRepresentation(ApplicationTest.getCurrentDir() + filename, MediaType.TEXT_XML);
            String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + frameworkName;
            Request request = ApplicationTest.getAuthenticatedRequest(Method.PUT, uri, loginUsername, loginPassword);
            request.setEntity((Representation)outfile);
            Response resp = new Client(Protocol.HTTP).handle(request);
            System.out.println(resp.getStatus());
            System.out.println(resp.getEntity());
        } else {
            System.out.println("Couldn't find file " + file.getName());
        }
    }

    public static void PostZipFile(String loginUsername, String loginPassword, String frameworkName, final String filename) {
        OutputRepresentation outfile = new OutputRepresentation(MediaType.APPLICATION_ZIP){

            public void write(OutputStream stream) throws IOException {
                byte[] outfile = ApplicationTest.getBytesFromFile(new File(ApplicationTest.getCurrentDir() + filename));
                stream.write(outfile);
            }
        };
        String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + frameworkName;
        Request request = ApplicationTest.getAuthenticatedRequest(Method.POST, uri, loginUsername, loginPassword);
        request.setEntity((Representation)outfile);
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus());
        System.out.println(resp.getEntity());
    }

    public static void PutFramework(String loginUsername, String loginPassword, String frameworkName) {
        String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + frameworkName;
        Request request = ApplicationTest.getAuthenticatedRequest(Method.PUT, uri, loginUsername, loginPassword);
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus());
        System.out.println(resp.getEntity());
    }

    public static void PutWorkspace(String loginUsername, String loginPassword, String workspaceName, boolean restricted) {
        try {
            DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
            Document d = representation.getDocument();
            Element root = d.createElement("ConfigWorkspace");
            d.appendChild(root);
            Element RestrictedElm = d.createElement("Restricted");
            RestrictedElm.appendChild(d.createTextNode(Boolean.toString(restricted)));
            root.appendChild(RestrictedElm);
            d.normalizeDocument();
            String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + workspaceName;
            Request request = ApplicationTest.getAuthenticatedRequest(Method.PUT, uri, loginUsername, loginPassword);
            request.setEntity((Representation)representation);
            Response resp = new Client(Protocol.HTTP).handle(request);
            System.out.println(resp.getStatus());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeleteAccount(String loginUsername, String loginPassword, String AccountName) {
        String uri = "http://134.117.62.118:8080/cdpp/admin/accounts/" + AccountName;
        Request request = ApplicationTest.getAuthenticatedRequest(Method.DELETE, uri, loginUsername, loginPassword);
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus() + " : " + resp.getLocationRef());
    }

    private static void writeRepresentation(Representation entity, String filename) {
        try {
            FileOutputStream osfile = new FileOutputStream(filename);
            BufferedOutputStream buff = new BufferedOutputStream(osfile);
            DataOutputStream data = new DataOutputStream(buff);
            entity.write((OutputStream)data);
            data.close();
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    public static void DeleteWorkspace(String loginUsername, String loginPassword, String workspaceName) {
        String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + workspaceName;
        Request request = ApplicationTest.getAuthenticatedRequest(Method.DELETE, uri, loginUsername, loginPassword);
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus() + " : " + resp.getLocationRef());
    }

    public static void DeleteService(String loginUsername, String loginPassword, String serviceName) {
        String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + serviceName;
        Request request = ApplicationTest.getAuthenticatedRequest(Method.DELETE, uri, loginUsername, loginPassword);
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus() + " : " + resp.getLocationRef());
    }

    public static void DeleteFramework(String loginUsername, String loginPassword, String frameworkName) {
        String uri = "http://134.117.62.118:8080/cdpp/sim/workspaces/" + frameworkName;
        Request request = ApplicationTest.getAuthenticatedRequest(Method.DELETE, uri, loginUsername, loginPassword);
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus() + " : " + resp.getLocationRef());
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }
}

