#include (occupancy.inc)

[top]
components : occupancy

[occupancy]
type : cell
dim : (10,22,2)
delay : transport
defaultDelayTime : 100
border : nowrapped 
neighbors : occu(-1,-1,0) occu(-1,0,0) occu(-1,1,0)   %neighbors
neighbors : occu(0,-1,0)  occu(0,0,0)  occu(0,1,0) 
neighbors : occu(1,-1,0)  occu(1,0,0)  occu(1,1,0)
neighbors :               occu(0,0,-1)                %downstair
neighbors :               occu(0,0,1)                 %upstair

initialValue : 0
localTransition : occupancyRules

stateVariables : layout hotzone pathway 
stateValues : 0 0 0
initialvariablesvalue : occupancy.stvalues

neighborports: movement phase

[occupancyRules]

%new people //gate, on path way, simulation multiple of 500 //if(uniform(0,1)<0.1, 0, 1)  stairsOnF1(3.1->5) stairOnF2(3.2->6)
rule : {~movement := 1; ~phase := 1;} 0 { (0,0,0) = 1 and (0,0,0)~phase = 0 and $layout = 3 and $pathway >= 5 }
rule : {~movement := 1.5; ~phase := 1;} 0 { uniform(0,1)<#Macro(VisitorFrequency) and (0,0,0)~phase = 1 and (0,0,0)~movement = 0 and $layout = 3 and $pathway >= 5 and remainder(time, 500)=100 }
rule : {~movement := 1; ~phase := 1;} 0 { (0,0,0)~phase = 1 and (0,0,0)~movement = 1.5 and $layout = 3 and $pathway >= 5 }

%exit //when occupied, leave for empty
rule : {~movement := 0;} 100 { (0,0,0) = 1 and $layout = 4 and (0,0,0)~movement = 1} 

%phase 1: intent //if pathway done, order: %F; %LF, %RF; %L, %R; %B; %LB; %RB 
rule : {~movement := 10; ~phase := 2;} 100 { (0,0,0)~phase = 1 and (0,0,0)~movement = 1 and $layout = 5}  %upstair, intent to go down
rule : {~movement := uniform(0,1); ~phase := 1.1;} 100 { (0,0,0)~phase = 1 and (0,0,0)~movement = 1  and $pathway >= 5}   %inside the floor
rule : {~movement := 11; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 5 and (0,0,0)~movement > 0.0 and (0,0,0)~movement <= #Macro(Front) } %right move intent probability
rule : {~movement := 12; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 5 and (0,0,0)~movement > #Macro(Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front) }
rule : {~movement := 18; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 5 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) }
rule : {~movement := 13; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 5 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) }
rule : {~movement := 17; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 5 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) }
rule : {~movement := 15; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 5 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) }
rule : {~movement := 14; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 5 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) }
rule : {~movement := 16; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 5 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) and (0,0,0)~movement < 1 }

rule : {~movement := 13; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 6 and (0,0,0)~movement > 0.0 and (0,0,0)~movement <= #Macro(Front) } %up move intent probability
rule : {~movement := 14; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 6 and (0,0,0)~movement > #Macro(Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front) }
rule : {~movement := 12; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 6 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) }
rule : {~movement := 15; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 6 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) }
rule : {~movement := 11; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 6 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) }
rule : {~movement := 17; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 6 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) }
rule : {~movement := 16; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 6 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) }
rule : {~movement := 18; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 6 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) and (0,0,0)~movement < 1 }

rule : {~movement := 15; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 7 and (0,0,0)~movement > 0.0 and (0,0,0)~movement <= #Macro(Front) } %left move intent probability
rule : {~movement := 14; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 7 and (0,0,0)~movement > #Macro(Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front) }
rule : {~movement := 16; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 7 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) }
rule : {~movement := 13; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 7 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) }
rule : {~movement := 17; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 7 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) }
rule : {~movement := 11; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 7 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) }
rule : {~movement := 12; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 7 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) }
rule : {~movement := 18; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 7 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) and (0,0,0)~movement < 1 }

rule : {~movement := 17; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 8 and (0,0,0)~movement > 0.0 and (0,0,0)~movement <= #Macro(Front) } %down move intent probability
rule : {~movement := 16; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 8 and (0,0,0)~movement > #Macro(Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front) }
rule : {~movement := 18; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 8 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) }
rule : {~movement := 15; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 8 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) }
rule : {~movement := 11; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 8 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) }
rule : {~movement := 13; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 8 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) }
rule : {~movement := 12; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 8 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) and (0,0,0)~movement <= #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) }
rule : {~movement := 14; ~phase := 2;} 100 { (0,0,0)~phase = 1.1 and $pathway = 8 and (0,0,0)~movement > #Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) and (0,0,0)~movement < 1 }

%phase 2: grant 
rule : {~movement := 40; ~phase := 4;} 100 { (0,0,0)~movement = 0 and (0,0,-1)~movement = 10 }   %downstair to choose
rule : {~movement := 41; ~phase := 4;} 100 { (0,0,0)~movement = 0 and (0,-1,0)~movement = 11 and $layout != 2}   %choose one neighbor to come in
rule : {~movement := 42; ~phase := 4;} 100 { (0,0,0)~movement = 0 and (1,-1,0)~movement = 12 and $layout != 2}
rule : {~movement := 43; ~phase := 4;} 100 { (0,0,0)~movement = 0 and (1,0,0)~movement = 13 and $layout != 2}
rule : {~movement := 44; ~phase := 4;} 100 { (0,0,0)~movement = 0 and (1,1,0)~movement = 14 and $layout != 2}
rule : {~movement := 45; ~phase := 4;} 100 { (0,0,0)~movement = 0 and (0,1,0)~movement = 15 and $layout != 2}
rule : {~movement := 46; ~phase := 4;} 100 { (0,0,0)~movement = 0 and (-1,1,0)~movement = 16 and $layout != 2}
rule : {~movement := 47; ~phase := 4;} 100 { (0,0,0)~movement = 0 and (-1,0,0)~movement = 17 and $layout != 2}
rule : {~movement := 48; ~phase := 4;} 100 { (0,0,0)~movement = 0 and (-1,-1,0)~movement = 18 and $layout != 2}
rule : {~movement := ((0,0,0)~movement+10); ~phase := 3;} 100 { (0,0,0)~movement >= 10 and (0,0,0)~movement <= 18 }

%phase 3: ack, waiting // if intent doesn't grant, turn 39 and stay; random waiting (adding hotzone), random time not working (100 + 500*randInt($hotzone + 1)
rule : {~movement := 30; ~phase := 4;} 100 { (0,0,0)~phase = 3 and (0,0,0)~movement = 20 and (0,0,1)~movement = 40 }   %upstair ack
rule : {~movement := 31; ~phase := 4;} { 600 + 500* $hotzone } { (0,0,0)~phase = 3 and (0,0,0)~movement = 21 and (0,1,0)~movement = 41 }
rule : {~movement := 32; ~phase := 4;} { 600 + 500* $hotzone } { (0,0,0)~phase = 3 and (0,0,0)~movement = 22 and (-1,1,0)~movement = 42 }
rule : {~movement := 33; ~phase := 4;} { 600 + 500* $hotzone } { (0,0,0)~phase = 3 and (0,0,0)~movement = 23 and (-1,0,0)~movement = 43 }
rule : {~movement := 34; ~phase := 4;} { 600 + 500* $hotzone } { (0,0,0)~phase = 3 and (0,0,0)~movement = 24 and (-1,-1,0)~movement = 44 }
rule : {~movement := 35; ~phase := 4;} { 600 + 500* $hotzone } { (0,0,0)~phase = 3 and (0,0,0)~movement = 25 and (0,-1,0)~movement = 45 }
rule : {~movement := 36; ~phase := 4;} { 600 + 500* $hotzone } { (0,0,0)~phase = 3 and (0,0,0)~movement = 26 and (1,-1,0)~movement = 46 }
rule : {~movement := 37; ~phase := 4;} { 600 + 500* $hotzone } { (0,0,0)~phase = 3 and (0,0,0)~movement = 27 and (1,0,0)~movement = 47 }
rule : {~movement := 38; ~phase := 4;} { 600 + 500* $hotzone } { (0,0,0)~phase = 3 and (0,0,0)~movement = 28 and (1,1,0)~movement = 48 }
rule : {~movement := 39; ~phase := 4;} 100 { (0,0,0)~phase = 3 and (0,0,0)~movement >= 20 and (0,0,0)~movement <= 28 }

%phase 4: move 
rule : {~movement := 0; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 30 and (0,0,1)~movement = 40 } %phase 4: move from
rule : {~movement := 0; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 31 and (0,1,0)~movement = 41 } 
rule : {~movement := 0; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 32 and (-1,1,0)~movement = 42 } 
rule : {~movement := 0; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 33 and (-1,0,0)~movement = 43 } 
rule : {~movement := 0; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 34 and (-1,-1,0)~movement = 44 } 
rule : {~movement := 0; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 35 and (0,-1,0)~movement = 45 } 
rule : {~movement := 0; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 36 and (1,-1,0)~movement = 46 } 
rule : {~movement := 0; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 37 and (1,0,0)~movement = 47 } 
rule : {~movement := 0; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 38 and (1,1,0)~movement = 48 } 

rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement >= 30 and (0,0,0)~movement <= 39 }                           %phase 4: cannot move from, remain 1
rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 40 and (0,0,-1)~movement = 30}   %phase 4: move down //stair
rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 41 and (0,-1,0)~movement = 31}   %phase 4: move to
rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 42 and (1,-1,0)~movement = 32}
rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 43 and (1,0,0)~movement = 33}
rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 44 and (1,1,0)~movement = 34}
rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 45 and (0,1,0)~movement = 35}
rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 46 and (-1,1,0)~movement = 36}
rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 47 and (-1,0,0)~movement = 37}
rule : {~movement := 1; ~phase := 1;} 100 { (0,0,0)~phase = 4 and (0,0,0)~movement = 48 and (-1,-1,0)~movement = 38}

%initial
rule : {1} {$layout:=$layout; $hotzone:=$hotzone; $pathway:=$pathway;} 0 { (0,0,0) = 0 }  %//magic line, variables need to be initialized
rule : { } 0 { t }








