
 #ifndef __MYPROCESSOR_H
 #define __MYPROCESSOR_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class myProcessor : public Atomic{
   public:
	       myProcessor( const std::string &name = "myProcessor" );	//Default constructor
	       virtual std::string className() const { return "myProcessor"; }
	       ~myProcessor();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In,&Ask;
	        Port &Out;
	        Time ProcessTime;
	        int id;
	        int isGenerator;
	        int msgToSend;
	        int msgCounter;
	        int askForTask;
         	enum State{
			            Idle,       //initial state
			            Task,
			            Generate,
		              };
		    State state;
 };	// class myProcessor

 #endif   //__MYPROCESSOR_H
