
#ifndef __BUFFER_H
 #define __BUFFER_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class Buffer : public Atomic
 {
   public:
	       Buffer( const std::string &name = "Buffer" );	//Default constructor
	       virtual std::string className() const { return "Buffer"; }
	       ~Buffer();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In,&Ask;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        int Request;
	        int Qlen;
	        int id;
         	enum State{
			            Idle,       //initial state
			            Push,
			            Pop,
		              };
		    State state;
 };	// class Buffer

 #endif   //__BUFFER_H
