/*******************************************************************
*
*  DESCRIPTION: Atomic Model RivetBuffer
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __RIVETBUFFER_H
#define __RIVETBUFFER_H

#include <list>
#include "atomic.h"     // class Atomic

class RivetBuffer : public Atomic
{
public:
	RivetBuffer( const string &name = "RivetBuffer" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &inform;
	const Port &done;
	Port &out, &mg;
	Time preparationTime;

	typedef list<Value> ElementList ;
	ElementList elements ;

	enum State{
			collecting ,
			sending
			};

			State state;

};	// class RivetBuffer

// ** inline ** // 
inline
string RivetBuffer::className() const
{
	return "RivetBuffer" ;
}

#endif   //__RIVETBUFFER_H
