/*******************************************************************
*
*  DESCRIPTION: Atomic Model Refine
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

/** include files **/
#include "refine.h"      // class Refine
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )


/** public functions **/

/*******************************************************************
* Function Name: Refine
* Description:
********************************************************************/
Refine::Refine( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, inform( addInputPort( "inform" ) )
, out( addOutputPort( "out" ) )
, done( addOutputPort( "done" ) )
, preparationTime( 0, 0, 3, 0 )
{	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description:
********************************************************************/
Model &Refine::initFunction()
{
	state = waiting;

	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Refine::externalFunction( const ExternalMessage &msg )
{

	if (msg.port() == inform && state == waiting)
	{
		state = requesting;
		holdIn(active, Time::Zero );
	}

	if( msg.port() == in  && state != processing)
	{
		state = processing;

		holdIn(active, preparationTime );	// hold it for some time as processing time, then send output (call output function)
	}
// other situations [such as: if (msg.port() == inform && state != waiting)or other)] could happen but will not cause any lose in materials or affect any thing
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Refine::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Refine::outputFunction( const InternalMessage &msg )
{
	switch (state)
		{
			case requesting :
				// request new elements from buffer
				sendOutput ( msg.time(), done, 1 );

				break;


			case processing :
				// send the output and change the state to waiting in order to request new elements...
				sendOutput( msg.time(), out, 1 ) ;

				sendOutput ( msg.time(), done, 1 );

				state = waiting;
				break;
		}

	return *this ;
}
