/*******************************************************************
*
*  DESCRIPTION: Atomic Model PeelBuffer
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __PEELBUFFER_H
#define __PEELBUFFER_H

#include <list>
#include "atomic.h"     // class Atomic

class PeelBuffer : public Atomic
{
public:
	PeelBuffer( const string &name = "PeelBuffer" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &mg;
	const Port &done;
	Port &out;
	Time preparationTime;
	typedef list<Value> ElementList ;
	ElementList elements ;

	unsigned int        BufferMaxSize;


};	// class PeelBuffer

// ** inline ** // 
inline
string PeelBuffer::className() const
{
	return "PeelBuffer" ;
}

#endif   //__PEELBUFFER_H
