/*******************************************************************
*
*  DESCRIPTION: Atomic Model PackageBuffer
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __PACKAGEBUFFER_H
#define __PACKAGEBUFFER_H

#include <list>
#include "atomic.h"     // class Atomic

class PackageBuffer : public Atomic
{
public:
	PackageBuffer( const string &name = "PackageBuffer" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &inform;
	const Port &done;
	Port &out, &mg;
	Time preparationTime;

	typedef list<Value> ElementList ;
	ElementList elements ;

	enum State{
			collecting ,
			sending
			};

			State state;

};	// class PackageBuffer

// ** inline ** // 
inline
string PackageBuffer::className() const
{
	return "PackageBuffer" ;
}

#endif   //__PACKAGEBUFFER_H
