/*******************************************************************
*
*  DESCRIPTION: Atomic Model CheckBuffer
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CHECKBUFFER_H
#define __CHECKBUFFER_H

#include <list>
#include "atomic.h"     // class Atomic

class CheckBuffer : public Atomic
{
public:
	CheckBuffer( const string &name = "CheckBuffer" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &inform;
	const Port &done;
	Port &out, &mg;
	Time preparationTime;

	typedef list<Value> ElementList ;
	ElementList elements ;

	enum State{
			collecting ,
			sending
			};

			State state;

};	// class CheckBuffer

// ** inline ** // 
inline
string CheckBuffer::className() const
{
	return "CheckBuffer" ;
}

#endif   //__CHECKBUFFER_H
