/*******************************************************************
*
*  DESCRIPTION: Atomic Model Rivet
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __RIVET_H
#define __RIVET_H


#include "atomic.h"     // class Atomic

class Rivet : public Atomic
{
public:
	Rivet( const string &name = "Rivet" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in, &inform;
	Port &out;
	Port &done;
	Time preparationTime;

	enum State{
				processing ,
				requesting ,
				waiting
				};

		State state;

};	// class Rivet

// ** inline ** //
inline
string Rivet::className() const
{
	return "Rivet" ;
}

#endif   //__RIVET_H
