/*******************************************************************
*
*  DESCRIPTION: Atomic Model Package
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __PACKAGE_H
#define __PACKAGE_H


#include "atomic.h"     // class Atomic

class Package : public Atomic
{
public:
	Package( const string &name = "Package" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in, &inform;
	Port &out;
	Port &done;
	Port &fpCount;
	Time preparationTime;

	enum State{
				processing ,
				requesting ,
				waiting
				};

		State state;

		int counter; // to count finished product


};	// class Package

// ** inline ** //
inline
string Package::className() const
{
	return "Package" ;
}

#endif   //__PACKAGE_H
