/*******************************************************************
*
*  DESCRIPTION: Atomic Model Controller
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CONTROLLER_H
#define __CONTROLLER_H


#include "atomic.h"     // class Atomic

class Controller : public Atomic
{
public:
	Controller( const string &name = "Controller" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	Port &inCounter1 , &inCounter2, &inform;
	Time preparationTime;

	int counter1 , counter2;


};	// class ClipCableAssemble

// ** inline ** //
inline
string Controller::className() const
{
	return "Controller" ;
}

#endif   //__CONTROLLER_H
