/*******************************************************************
*
*  DESCRIPTION: Atomic Model ClipSource
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CLIPSOURCE_H
#define __CLIPSOURCE_H


#include "atomic.h"     // class Atomic

class ClipSource : public Atomic
{
public:
	ClipSource( const string &name = "ClipSource" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &out , &mg , &rmCount;
	Time preparationTime;

	int BufferMaxSize; // used for compression with received buffer size in order to send or not
	int requierdToSend; // to check how many RM should be sent to fill up the buffer

	enum State{
		generate ,
		wait
	};

	State state;
	int counter; //to count RM

	Time timeLeft; // we will use it to sent immediately
};	// class ClipSource

// ** inline ** //
inline
string ClipSource::className() const
{
	return "ClipSource" ;
}

#endif   //__CLIPSOURCE_H
