/*******************************************************************
*
*  DESCRIPTION: Atomic Model ClipCableAssemble
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CLIPCABLEASSEMBLE_H
#define __CLIPCABLEASSEMBLE_H


#include "atomic.h"     // class Atomic

class ClipCableAssemble : public Atomic
{
public:
	ClipCableAssemble( const string &name = "ClipCableAssemble" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in1 , &in2 , &inform ;
	Port &out;
	Port &done;
	Time preparationTime;
	int input1 , input2;


	enum State{
			processing ,
			requesting ,
			waiting
			};

	State state;

};	// class ClipCableAssemble

// ** inline ** //
inline
string ClipCableAssemble::className() const
{
	return "ClipCableAssemble" ;
}

#endif   //__CLIPCABLEASSEMBLE_H
