/*******************************************************************
*
*  DESCRIPTION: Atomic Model ClipBuffer
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CLIPBUFFER_H
#define __CLIPBUFFER_H

#include <list>
#include "atomic.h"     // class Atomic

class ClipBuffer : public Atomic
{
public:
	ClipBuffer( const string &name = "ClipBuffer" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &mg;
	const Port &done;
	const Port &counter;
	Port &out;
	Time preparationTime;
	typedef list<Value> ElementList ;
	ElementList elements ;

	enum State{
			collecting ,
			sending
		};

		State state;


};	// class ClipBuffer

// ** inline ** // 
inline
string ClipBuffer::className() const
{
	return "ClipBuffer" ;
}

#endif   //__CLIPBUFFER_H
