/*******************************************************************
*
*  DESCRIPTION: Atomic Model CableBuffer
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CABLEBUFFER_H
#define __CABLEBUFFER_H

#include <list>
#include "atomic.h"     // class Atomic

class CableBuffer : public Atomic
{
public:
	CableBuffer( const string &name = "CableBuffer" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &mg;
	const Port &done;
	const Port &counter;
	Port &out;

	Time preparationTime;

	typedef list<Value> ElementList ;
	ElementList elements ;

	enum State{
		collecting ,
		sending
		};

		State state;


};	// class CableBuffer

// ** inline ** // 
inline
string CableBuffer::className() const
{
	return "CableBuffer" ;
}

#endif   //__CABLEBUFFER_H
