/*******************************************************************
*
*  DESCRIPTION: Simulator::registerNewAtomics()
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#include "modeladm.h"
#include "mainsimu.h"
#include "cableSource.h"
#include "peelBuffer.h"
#include "peel.h"
#include "rivetBuffer.h"
#include "rivet.h"
#include "refineBuffer.h"
#include "refine.h"
#include "clipSource.h"
#include "clipAssembleBuffer.h"
#include "clipAssemble.h"
#include "clipBuffer.h"
#include "cableBuffer.h"
#include "controller.h"
#include "clipCableAssemble.h"
#include "checkBuffer.h"
#include "check.h"
#include "packageBuffer.h"
#include "package.h"



void MainSimulator::registerNewAtomics()
{
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<CableSource>() , "cableSource" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<PeelBuffer>() , "peelBuffer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Peel>() , "peel" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<RivetBuffer>() , "rivetBuffer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Rivet>() , "rivet" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<RefineBuffer>() , "refineBuffer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Refine>() , "refine" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<ClipSource>() , "clipSource" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<ClipAssembleBuffer>() , "clipAssembleBuffer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<ClipAssemble>() , "clipAssemble" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<ClipBuffer>() , "clipBuffer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<CableBuffer>() , "cableBuffer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Controller>() , "controller" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<ClipCableAssemble>() , "clipCableAssemble" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<CheckBuffer>() , "checkBuffer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Check>() , "check" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<PackageBuffer>() , "packageBuffer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Package>() , "package" ) ;

}
