/*******************************************************************
*
*  DESCRIPTION: Atomic Model Refine
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __REFINE_H
#define __REFINE_H


#include "atomic.h"     // class Atomic

class Refine : public Atomic
{
public:
	Refine( const string &name = "Refine" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in, &inform;
	Port &out;
	Port &done;
	Time preparationTime;

	enum State{
				processing ,
				requesting ,
				waiting
				};

		State state;

};	// class Refine

// ** inline ** //
inline
string Refine::className() const
{
	return "Refine" ;
}

#endif   //__REFINE_H
