/*******************************************************************
*
*  DESCRIPTION: Atomic Model Peel
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

/** include files **/
#include "peel.h"      // class Peel
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )


/** public functions **/

/*******************************************************************
* Function Name: Peel
* Description:
********************************************************************/
Peel::Peel( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, out( addOutputPort( "out" ) )
, done( addOutputPort( "done" ) )
, preparationTime( 0, 0, 3, 0 )
{	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description:
********************************************************************/
Model &Peel::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Peel::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == in )
	{
		holdIn(active, preparationTime );		// call output function
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Peel::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Peel::outputFunction( const InternalMessage &msg )
{

		sendOutput( msg.time(), out, 1 ) ;
		sendOutput ( msg.time(), done, 1 );

	return *this ;
}
