/*******************************************************************
*
*  DESCRIPTION: Atomic Model ClipBuffer
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

/** include files **/
#include "clipBuffer.h"      // class ClipBuffer
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: ClipBuffer
* Description: 
********************************************************************/
ClipBuffer::ClipBuffer( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, done( addInputPort( "done" ) )
, out( addOutputPort( "out" ) )
, mg( addOutputPort( "mg" ) )
, counter( addOutputPort( "counter" ) )
, preparationTime( 0, 0, 1, 0 )
{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description: in this function we will set the initial values of the Buffer
********************************************************************/
Model &ClipBuffer::initFunction()
{
	// initially we clean up the Buffer.
	elements.erase( elements.begin(), elements.end() ) ;

	state = collecting;

	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: 
********************************************************************/
Model &ClipBuffer::externalFunction( const ExternalMessage &msg )
{
	// incoming message to the (in) port
	if( msg.port() == in )
	{
		// add the new element to the back of the buffer.
		elements.push_back( msg.value() ) ;
		if (state != sending){
			state = collecting;
			holdIn( active, Time::Zero ); // call output function to send the size of the buffer to the controller...
		}

	}

	if( msg.port() == done )
	{
		state = sending;

		if( !elements.empty() )
			holdIn( active,  preparationTime ); // call output function
		else {
					state = collecting;
					holdIn( active, Time::Zero ); // call output function to send the size of the buffer to the controller...
				}

	}



	if( msg.port() == in && msg.port() == done )
		{
			elements.push_back( msg.value() ) ;
			state = sending;

			if( !elements.empty() )
				holdIn( active,  preparationTime ); // call output function
			else {
						state = collecting;
						holdIn( active, Time::Zero ); // call output function to send the size of the buffer to the controller...
					}

		}


	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: 
********************************************************************/
Model &ClipBuffer::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: 
********************************************************************/
Model &ClipBuffer::outputFunction( const InternalMessage &msg )
{
	switch (state)
	{
		case  collecting :
			// send the buffer size
				sendOutput( msg.time(), counter, elements.size() ) ;
				sendOutput( msg.time(), mg, elements.size() ) ;
				break;

		case sending :

			// send the element
			sendOutput( msg.time(), out, elements.front() ) ;

			elements.pop_front() ;// remove the element after we sent it to the assembler ....

			sendOutput( msg.time(), mg, elements.size() ) ;
			state = collecting;

			break;

	}

	return *this ;
}
