/*******************************************************************
*
*  DESCRIPTION: Atomic Model ClipAssemble
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CLIPASSEMBLE_H
#define __CLIPASSEMBLE_H


#include "atomic.h"     // class Atomic

class ClipAssemble : public Atomic
{
public:
	ClipAssemble( const string &name = "ClipAssemble" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	Port &out;
	Port &done;
	Time preparationTime;
};	// class ClipAssemble

// ** inline ** //
inline
string ClipAssemble::className() const
{
	return "ClipAssemble" ;
}

#endif   //__CLIPASSEMBLE_H
