/*******************************************************************
*
*  DESCRIPTION: Atomic Model Check
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CHECK_H
#define __CHECK_H


#include "atomic.h"     // class Atomic

class Check : public Atomic
{
public:
	Check( const string &name = "Check" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in, &inform;
	Port &out;
	Port &done;
	Time preparationTime;

	enum State{
				processing ,
				requesting ,
				waiting
				};

		State state;

};	// class Check

// ** inline ** //
inline
string Check::className() const
{
	return "Check" ;
}

#endif   //__CHECK_H
