/*******************************************************************
*
*  DESCRIPTION: Atomic Model CableSource
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CABLESOURCE_H
#define __CABLESOURCE_H


#include "atomic.h"     // class Atomic

class CableSource : public Atomic
{
public:
	CableSource( const string &name = "CableSource" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &out , &mg , &rmCount;
	Time preparationTime;

	int BufferMaxSize; // used for compression with received buffer size in order to send or not
	int requierdToSend; // to check how many RM should be sent to fill up the buffer

	enum State{
		generate ,
		wait
	};

	State state;

	int counter; // to count number of RM

};	// class CableSource

// ** inline ** //
inline
string CableSource::className() const
{
	return "CableSource" ;
}

#endif   //__CABLESOURCE_H
