/*******************************************************************
*
*  DESCRIPTION: Atomic Model RefineBuffer
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __REFINEBUFFER_H
#define __REFINEBUFFER_H

#include <list>
#include "atomic.h"     // class Atomic

class RefineBuffer : public Atomic
{
public:
	RefineBuffer( const string &name = "RefineBuffer" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &inform;
	const Port &done;
	Port &out, &mg;
	Time preparationTime;

	typedef list<Value> ElementList ;
	ElementList elements ;

	enum State{
			collecting ,
			sending
			};

			State state;

};	// class RefineBuffer

// ** inline ** // 
inline
string RefineBuffer::className() const
{
	return "RefineBuffer" ;
}

#endif   //__REFINEBUFFER_H
