/*******************************************************************
*
*  DESCRIPTION: Atomic Model Peel
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __PEEL_H
#define __PEEL_H


#include "atomic.h"     // class Atomic

class Peel : public Atomic
{
public:
	Peel( const string &name = "Peel" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	Port &out;
	Port &done;
	Time preparationTime;
};	// class Peel

// ** inline ** //
inline
string Peel::className() const
{
	return "Peel" ;
}

#endif   //__PEEL_H
