/*******************************************************************
*
*  DESCRIPTION: Atomic Model Controller
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

/** include files **/
#include "controller.h"      // class Controller
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )


/** public functions **/

/*******************************************************************
* Function Name: ClipCableAssemble
* Description:
********************************************************************/
Controller::Controller( const string &name )
: Atomic( name )
, inCounter1( addInputPort( "inCounter1" ) )
, inCounter2( addInputPort( "inCounter2" ) )
, inform( addOutputPort( "inform" ) )
, preparationTime( 0, 0, 2, 0 )
{	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description:
********************************************************************/
Model &Controller::initFunction()
{
	counter1 = 0;
	counter2 = 0;

	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Controller::externalFunction( const ExternalMessage &msg )
{

	if (msg.port() == inCounter1){

		counter1 = static_cast < int > (msg.value()) ;

		if (counter1 > 0 && counter2 > 0 ){
		// send to Clip Assemble to inform it that both buffers has at least one material ready
			holdIn(active, Time::Zero );
		}
	}

	if (msg.port() == inCounter2){

		counter2 = static_cast < int > (msg.value()) ;

		if (counter1 > 0 && counter2 > 0 ) {
			// send to Clip Assemble to inform it that both buffers has at least one material ready
			holdIn(active, Time::Zero );
		}
	}
	if (msg.port() == inCounter1 && msg.port() == inCounter2){

			counter1 = static_cast < int > (msg.value()) ;
			counter2 = static_cast < int > (msg.value()) ;

			if (counter1 > 0 && counter2 > 0 ){
			// send to Clip Assemble to inform it that both buffers has at least one material ready
				holdIn(active, Time::Zero );
			}
	}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Controller::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Controller::outputFunction( const InternalMessage &msg )
{
	// send to Clip Assemble to inform it that both buffers has at least one material ready
	sendOutput ( msg.time(), inform, 1 );

}
