/*******************************************************************
*
*  DESCRIPTION: Atomic Model ClipCableAssemble
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

/** include files **/
#include "clipCableAssemble.h"      // class ClipCableAssemble
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )


/** public functions **/

/*******************************************************************
* Function Name: ClipCableAssemble
* Description:
********************************************************************/
ClipCableAssemble::ClipCableAssemble( const string &name )
: Atomic( name )
, in1( addInputPort( "in1" ) )
, in2( addInputPort( "in2" ) )
, inform( addInputPort( "inform" ))
, out( addOutputPort( "out" ) )
, done( addOutputPort( "done" ) )
, preparationTime( 0, 0, 3, 0 )
{	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description:
********************************************************************/
Model &ClipCableAssemble::initFunction()
{
	state = waiting; // initial state waiting to get inform from controller if both buffers has elements ready to assembled
	// temp. variables to hold in1 and in2 messages since they may came in different times
	input1 =0;
	input2=0;

	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &ClipCableAssemble::externalFunction( const ExternalMessage &msg )
{

	if (msg.port() == inform && state == waiting ){

		// change state and call both buffers to get 2 elements for assembling
		state = requesting;
		holdIn(active, Time::Zero );
	}


	if (msg.port() == inform && state != waiting ){
		// this could happen but will not cause any lose in the material,
		// and the message will send again and again since the source in unlimited.
		}



	if( msg.port() == in1){

		input1 =  static_cast < int > (msg.value()) ; // just store the input element

		if (input1 > 0 && input2 > 0 && state != processing)
			{
				state = processing;
				//we have received both elements
				holdIn(active, preparationTime ); // just hold it for some time as processing time, then send output (call output function)
			}

	}

	if(   msg.port() == in2 ){

			input2 =  static_cast < int > (msg.value()) ; // just store the input element

			if (input1 > 0 && input2 > 0 && state != processing)
				{
					state = processing;
					//we have received both elements
					holdIn(active, preparationTime ); // just hold it for some time as processing time, then send output (call output function)
				}

		}

	if( msg.port() == in1 &&  msg.port() == in2 ){

				input1 =  static_cast < int > (msg.value()) ; // just store the input element
				input2 =  static_cast < int > (msg.value()) ; // just store the input element

				if (input1 > 0 && input2 > 0 && state != processing)
				{
						state = processing;
						//we have received both elements
						holdIn(active, preparationTime ); // just hold it for some time as processing time, then send output (call output function)
					}

			}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &ClipCableAssemble::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &ClipCableAssemble::outputFunction( const InternalMessage &msg )
{
	switch (state)
	{
		case requesting :
			// request new elements from both buffers
			// note that, we are sure both buffers has at least one element, since we receive inform from controller...
			sendOutput ( msg.time(), done, 1 );

			break;


		case processing :
			// send the output and change the state to waiting in order to inform about new elements...
			sendOutput( msg.time(), out, 1 ) ;

			state = waiting;
			break;

	}


	return *this ;
}
