/*******************************************************************
*
*  DESCRIPTION: Atomic Model ClipAssembleBuffer
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

#ifndef __CLIPASSEMBLEBUFFER_H
#define __CLIPASSEMBLEBUFFER_H

#include <list>
#include "atomic.h"     // class Atomic

class ClipAssembleBuffer : public Atomic
{
public:
	ClipAssembleBuffer( const string &name = "ClipAssembleBuffer" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &mg;
	const Port &done;
	Port &out;
	Time preparationTime;
	typedef list<Value> ElementList ;
	ElementList elements ;

	unsigned int        BufferMaxSize;


};	// class ClipAssembleBuffer

// ** inline ** // 
inline
string ClipAssembleBuffer::className() const
{
	return "ClipAssembleBuffer" ;
}

#endif   //__CLIPASSEMBLEBUFFER_H
