/*******************************************************************
*
*  DESCRIPTION: Atomic Model ClipAssemble
*
*  AUTHOR: Abdullah Alfaify
*
*  EMAIL: mailto://aalfa064@uottawa.ca
*
*  DATE: 14/12/2011
*
*******************************************************************/

/** include files **/
#include "clipAssemble.h"      // class ClipAssemble
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )


/** public functions **/

/*******************************************************************
* Function Name: ClipAssemble
* Description:
********************************************************************/
ClipAssemble::ClipAssemble( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, out( addOutputPort( "out" ) )
, done( addOutputPort( "done" ) )
, preparationTime( 0, 0, 3, 0 )
{	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description:
********************************************************************/
Model &ClipAssemble::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &ClipAssemble::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == in )
	{
		holdIn(active, preparationTime );		// call output function
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &ClipAssemble::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &ClipAssemble::outputFunction( const InternalMessage &msg )
{

		sendOutput( msg.time(), out, 1 ) ;
		sendOutput ( msg.time(), done, 1 );

	return *this ;
}
