[top]
components : sensor

[sensor]
type : cell
dim : (6,6,3)
delay : inertial
defaultDelayTime : 1000
border : nowrapped 

%defining neighborhood
neighbors : 	sensor(-1,-1,0) sensor(-1,0,0) sensor(-1,1,0) 
neighbors : 	sensor(0,-1,0)  sensor(0,0,0)  sensor(0,1,0)
neighbors : 	sensor(1,-1,0)  sensor(1,0,0)  sensor(1,1,0)
neighbors : 	sensor(0,0,1)
neighbors : 	sensor(0,0,-1)
neighbors : 	sensor(0,0,2)
neighbors : 	sensor(0,0,-2)

%defining zones
zone : media-access-rules { (0,0,2)..(5,5,2) }
zone : power-usage-rules { (0,0,1)..(5,5,1) }
localtransition : malware-propagation-rules

%initializing cells
initialvalue : 0
initialCellsValue : sensorNet.val

[media-access-rules]
%if any of the neighbors are broadcasting=32, set state to receive=31
rule : 31 			1000 	{ (0,0,0)=30 and statecount(32)>0}
%if the the current state is receive and none of the neighbors are broadcasting, set state to free=30
rule : 30			1000	{ (0,0,0)=31 and statecount(32)<1}
%if the node is infected=1 and media is free=30, start broadcasting=32
rule : 32			{round(uniform(1,10))*100} 	{ (0,0,-2)=1 and statecount(32)<1}			%{round(uniform(1,10))*100}
%after broadcasting, set media free=30
rule : 30			1000	{ (0,0,0)=32}
rule : {(0,0,0)}	1000	{t}  

[power-usage-rules]									%battery power of a node can vary from 10 to 20
%set power value of all non occupied cells to 10
rule : 10				1000		{ (0,0,-1)=-1}	
%if the power value is less than 11, make it 10
rule : 10                1000		{ (0,0,0)<=11 } 
%power consumption rate of infected cells					
rule : {(0,0,0)*.9}	1000		{(0,0,-1)=1} 
%power consumption rate of susceptible and recovered nodes		
rule : {(0,0,0)*1.0}	1000		{(0,0,-1)=0 or (0,0,-1)=2 } 								
rule : 10				1000		{t}  

[malware-propagation-rules]	
%if battery power is less than 11, node will die
rule : -1 			1000 	{ (0,0,1)<11 }
%if susceptible node received malware message, go infected_spread=1
rule : 1 			1000 	{ ((0,0,0)=0 and (0,0,2)=31)}	%and round(uniform(0,9))<5
%after doing a broadcast, go infected_dormant=2
rule : 2 			1000 	{ (0,0,2)=32}	
%after staying in infected_dormant=2, go back to infected_spread=1
rule : 1			5000	{ (0,0,0)=2}		
rule : {(0,0,0)} 	1000 	{t}	