[top]
components : sensormal

[sensormal]
type : cell
dim : (25,25)
delay : transport
defaultDelayTime : 100
border : nowrapped 

%defining neighborhood
neighbors :  sensor(-1,-1)  sensor(-1,0) sensor(-1,1) 
neighbors :  sensor(0,-1)  sensor(0,0)  sensor(0,1)
neighbors :  sensor(1,-1)  sensor(1,0)  sensor(1,1)

% Pre-initialization
initialCellsValue : sensormal.val
initialValue : 0
neighborports : node pwr txrx
localtransition :  MalwareRules


[MalwareRules]
%5 if node=dead(-1) stay dead (-1)
rule : { } 100 { (0,0)~node = -1 }

%any state can go dead
%6 if ~pwr <=1, make node dead(-1) and power 0
rule : { ~node := -1; ~pwr := 0; ~txrx := 0; } 100 { (0,0)~pwr <= 1 }

%7 if node=sleep(0), go active(1)with 0.4 probability, reducing power by 0.1 
rule : { ~node := 1; ~pwr := (0,0)~pwr - 0.1; } 100 { (0,0)~node = 0 and round(uniform(1,10)) > 6 }

%8 if node=sleep(0), stay sleep and reduce power by 0.1
rule : { ~pwr := (0,0)~pwr - 0.1; } 100 { (0,0)~node = 0 }

%9 if node=patched_sleep(5), go patched_active with probability given by a linear function of number of infected neighbors, reducing power by 0.1
rule : { ~node := 4; ~pwr := (0,0)~pwr - 0.1; } 100 { (0,0)~node = 5 and round(uniform(1,10)) <= (statecount(2, ~node)*3 + 4 ) }

%10 if node=patched_sleep(5), stay sleep and reduce power by 0.1
rule : { ~pwr := (0,0)~pwr - 0.1; } 100 { (0,0)~node = 5 }

%11 if node=active or spreading and any of the neighbors transmitting patch, go patched_active 
rule : { ~node := 4; ~pwr := (0,0)~pwr - 0.2; } 100 { statecount(3, ~txrx) > 0 and ( (0,0)~node = 1 or (0,0)~node = 2 ) }

%12 if node=active(1), and only one neighbor is txrx=malware_bcast(2) while none have txrx=1, go spreading(2) and reduce pwr by 0.2. 
rule : { ~node := 2; ~pwr := (0,0)~pwr - 0.2; } 100 { (0,0)~node = 1 and ( statecount(2, ~txrx) = 1 and statecount(1, ~txrx) = 0 ) }
% this rule assumes if more than one neighbor is broadcasting, it results collision and no message is received

%13 if node=spreading(2) and txrx=malware_bcast(2), set txrx to none(0), reduce power by 1 and go dormant(3)
rule : { ~txrx := 0; ~node := 3; ~pwr := (0,0)~pwr - 1; } 100 { (0,0)~node = 2 and (0,0)~txrx = 2 }

%14 if node=spreading(2)and none of the neighbors have txrx=1, set txrx to malware_bcast(2) and reduce power by 0.5
rule : { ~txrx := 2; ~pwr := (0,0)~pwr - 0.5; } 100 { (0,0)~node = 2 and statecount(1, ~txrx ) = 0}
% in this rule, following pre-conditions can be used to show MAC control for malware spreading
% and ( statecount(1, ~txrx ) = 0 and statecount(2, ~txrx) = 0 ) 

%15 if node=spreading(2) and could not broadcast due to busy channel, stay spreading(2) and reduce power by 0.5 
rule : { ~pwr := (0,0)~pwr - 0.5; } 100 { (0,0)~node = 2 }

%16 if node=dormant(3), reduce pwr by 0.2 and go spreading 
rule : { ~node := 2; ~pwr := (0,0)~pwr - 0.2; } 100 { (0,0)~node = 3 and round(uniform(1,10)) > (statecount(2, ~node)*2 + 2 ) }

%17 if still node=dormant(3), stay dormant and reduce power by 0.2
rule : { ~pwr := (0,0)~pwr - 0.2; } 100 { (0,0)~node = 3 }

%18 if node=patched_active(4) and txrx=patch(3) or normal_ch_access(1), set txrx=none(0) and go patched_sleep(5)
rule : { ~txrx := 0; ~node := 5; ~pwr := (0,0)~pwr - 0.2; } 100 { (0,0)~node = 4 and ( (0,0)~txrx = 3 or (0,0)~txrx = 1 ) }

%19 if node=patched_active(4) , transmit patch(3) with probability given by a linear function of number of spreading neighbors
rule : { ~txrx := 3; ~pwr := (0,0)~pwr - 0.2; } 100 { (0,0)~node = 4 and round(uniform(1,10)) <= (statecount(2, ~node)*4 + 2 ) }

%20 if node=susceptible_active(1), go back to sleep with 0.4 probability, without transmitting any message 
%this state represents message to be transmitted is timed out and events that does not require data transmission .
rule : { ~txrx := 0; ~node := 0; ~pwr := (0,0)~pwr - 0.2; } 100 { (0,0)~node = 1 and round(uniform(1,10)) > 6 }

%21 if node=patched_active(1), go back to patched_sleep with 0.4 probability, if no infected_spreading nodes in the neighborhood 
rule : { ~txrx := 0; ~node := 5; ~pwr := (0,0)~pwr - 0.2; } 100 { (0,0)~node = 4 and round(uniform(1,10)) <= (statecount(2, ~node)*6 + 4 ) }

%22 if node=active(1) and txrx=normal_ch_access(1), set txrx to none(0), reduce power by 0.2 and go sleep(0) 
rule : { ~txrx := 0; ~node := 0; ~pwr := (0,0)~pwr - 0.2; } 100 { (0,0)~node = 1 and (0,0)~txrx = 1 }

%23 if node=active(1) or patched_active(4) and none of the neighbors have txrx=1 or txrx=2, set txrx to normal_ch_access(1) and reduce power by 0.2
rule : { ~txrx := 1; ~pwr := (0,0)~pwr - 0.2; } 100 { ( (0,0)~node = 1 or (0,0)~node = 4 ) and ( statecount(1, ~txrx) = 0 and statecount(2, ~txrx) = 0 ) }

%24 if node=active(1) or patched_active(4) and more than one nodes access channel, stay active and reduce power by 0.2
rule : { ~pwr := (0,0)~pwr - 0.2; } 100 { (0,0)~node = 1 or (0,0)~node = 4 }

% Actual initialization
%1 initializing sensor nodes as active in 0.5 probability
rule : { ~node := 1; ~pwr := 20; ~txrx := 0; } 100 { (0,0)~node = 99 and ( (0,0)~pwr = 99 and round(uniform(1,10)) > 5 ) }
%2 initializing sensor nodes as active in 0.5 probability
rule : { ~node := 0; ~pwr := 20; ~txrx := 0; } 100 { (0,0)~node = 99 and (0,0)~pwr = 99 }
%3 initializing spreading node
rule : { ~node := 2; ~pwr := 20; ~txrx := 2; } 100 { (0,0)~node = 100 and (0,0)~pwr = 100 }
%4 initializing patched node
rule : { ~node := 4; ~pwr := 20; ~txrx := 3; } 100 { (0,0)~node = 101 and (0,0)~pwr = 101 }

%25 default rule which should be given attention
rule : { ~node := 50; ~pwr := 50; ~txrx := 50; }  100  { t }
