/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.util.SslContextFactory;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.data.Parameter;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSslContextFactory
extends SslContextFactory {
    private String keyManagerAlgorithm = System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm());
    private char[] keyStoreKeyPassword = System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")) != null ? System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")).toCharArray() : null;
    private char[] keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword") != null ? System.getProperty("javax.net.ssl.keyStorePassword").toCharArray() : null;
    private String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
    private String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
    private String secureRandomAlgorithm = null;
    private String secureSocketProtocol = "TLS";
    private String trustManagerAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm());
    private char[] trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword") != null ? System.getProperty("javax.net.ssl.trustStorePassword").toCharArray() : null;
    private String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private String trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
    private String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");

    protected final DefaultSslContextFactory clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLContext createSslContext() throws Exception {
        KeyManagerFactory kmf = null;
        if (this.keyStorePath != null || this.keyStoreProvider != null || this.keyStoreType != null) {
            KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
            FileInputStream keyStoreInputStream = null;
            try {
                keyStoreInputStream = this.keyStorePath != null && !"NONE".equals(this.keyStorePath) ? new FileInputStream(this.keyStorePath) : null;
                keyStore.load(keyStoreInputStream, this.keyStorePassword);
            }
            finally {
                if (keyStoreInputStream != null) {
                    keyStoreInputStream.close();
                }
            }
            kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
            kmf.init(keyStore, this.keyStoreKeyPassword);
        }
        TrustManagerFactory tmf = null;
        if (this.trustStorePath != null || this.trustStoreProvider != null || this.trustStoreType != null) {
            KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
            FileInputStream trustStoreInputStream = null;
            try {
                trustStoreInputStream = this.trustStorePath != null && !"NONE".equals(this.trustStorePath) ? new FileInputStream(this.trustStorePath) : null;
                trustStore.load(trustStoreInputStream, this.trustStorePassword);
            }
            finally {
                if (trustStoreInputStream != null) {
                    trustStoreInputStream.close();
                }
            }
            tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
            tmf.init(trustStore);
        }
        SSLContext sslContext = SSLContext.getInstance(this.secureSocketProtocol);
        SecureRandom sr = null;
        if (this.secureRandomAlgorithm != null) {
            sr = SecureRandom.getInstance(this.secureRandomAlgorithm);
        }
        sslContext.init(kmf != null ? kmf.getKeyManagers() : null, tmf != null ? tmf.getTrustManagers() : null, sr);
        return sslContext;
    }

    public String getSecureSocketProtocol() {
        return this.secureSocketProtocol;
    }

    @Override
    public void init(Series<Parameter> helperParameters) {
        this.setKeyStorePath(helperParameters.getFirstValue("keystorePath", System.getProperty("javax.net.ssl.keyStore", System.getProperty("user.home") + File.separator + ".keystore")));
        this.setKeyStorePassword(helperParameters.getFirstValue("keystorePassword", System.getProperty("javax.net.ssl.keyStorePassword", "")));
        this.setKeyStoreType(helperParameters.getFirstValue("keystoreType", System.getProperty("javax.net.ssl.keyStoreType")));
        this.setKeyStoreKeyPassword(helperParameters.getFirstValue("keyPassword", System.getProperty("javax.net.ssl.keyPassword", "")));
        this.setTrustStorePath(helperParameters.getFirstValue("truststorePath", System.getProperty("javax.net.ssl.trustStore")));
        this.setTrustStorePassword(helperParameters.getFirstValue("truststorePassword", System.getProperty("javax.net.ssl.trustStorePassword")));
        this.setTrustStoreType(helperParameters.getFirstValue("truststoreType", System.getProperty("javax.net.ssl.trustStoreType")));
        this.setKeyManagerAlgorithm(helperParameters.getFirstValue("certAlgorithm", "SunX509"));
        this.setSecureSocketProtocol(helperParameters.getFirstValue("sslProtocol", "TLS"));
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public final void setKeyStoreKeyPassword(char[] keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword;
    }

    public final void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword != null ? keyStoreKeyPassword.toCharArray() : null;
    }

    public final void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public final void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
    }

    public final void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public final void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public void setSecureSocketProtocol(String secureSocketProtocol) {
        this.secureSocketProtocol = secureSocketProtocol;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
    }

    public final void setTrustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public final void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword != null ? trustStorePassword.toCharArray() : null;
    }

    public final void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public final void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public final void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }
}

