/*******************************************************************
*
*  DESCRIPTION: CLASS SimLoader
*
*  AUTHOR:    Amir Barylko & Jorge Beyoglonian 
*  Version 2: Daniel Rodriguez.
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/06/1998
*  DATE: 11/04/1999 (v2)
*
*******************************************************************/

#ifndef __LOADER_H
#define __LOADER_H

/** include files **/
#include "cdtime.h"
#include "evaldeb.h"		// EvalDebug

/** forward declarations **/
//class iostream  ;
class MainSimulator ;

/** declarations **/

class SimLoader
{
public:
	virtual istream &modelsStream()
			{return *models;}
			
	virtual istream &eventsStream()
			{return *events;}

	virtual ostream &logStream()
			{return *log;}

	virtual ostream &outputStream()
			{return *output;}

	const Time &stopTime() const
			{return stop;}
			
	bool printParserInfo() const
			{return printParser;}

	virtual ~SimLoader(){}				//Destructor

protected:
	friend class MainSimulator ;

	// ** Instance variables ** //
	Time stop ;
	bool printParser ;
	istream *models ;
	istream *events ;
	ostream *log ;
	ostream *output ;


	// ** Methods ** //
	SimLoader()					//Default constructor
		: models( NULL )
		, events( NULL )
		, log( NULL )
		{	EvalDebug().Stream( NULL );
			EvalDebug().Active( false );
		}


	virtual SimLoader &loadData() = 0;
	virtual SimLoader &writeResults() = 0;

	SimLoader &stopTime( const Time &t )
			{stop = t; return *this;}

	SimLoader &printParserInfo (const bool pp)
			{printParser = pp; return *this;}

};	// class SimLoader

#endif   //__LOADER_H 
