/*******************************************************************
*
*  DESCRIPTION: class Generator
*
*  AUTHOR: Amir Barylko & Jorge Beyoglonian 
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*
*  DATE: 27/6/1998
*
*******************************************************************/

#ifndef __GENERATOR_H
#define __GENERATOR_H

/** include files **/
#include "atomic.h"     // class Atomic
#include "except.h"     // class InvalidMessageException

/** forward declarations **/
class Distribution ;

/** declarations **/
class Generator : public Atomic
{
public:
	Generator( const string &name = "Generator" );				  // Default constructor

	~Generator();

	virtual string className() const
		{return "Generator";}

protected:
	Model &initFunction() ;

	Model &externalFunction( const ExternalMessage & )
			{throw InvalidMessageException();}

	Model &internalFunction( const InternalMessage & );

	Model &outputFunction( const InternalMessage & );

private:
	int pid;
	int initial, increment;
	Port &out ;
	Distribution *dist ;

	Distribution &distribution()
			{return *dist;}
			
};	// class Generator


#endif   //__GENERATOR_H 
