/*******************************************************************
*
*  DESCRIPTION: CLASS EvalDebug
*
*  AUTHOR:    Daniel Rodriguez.
*
*  EMAIL: mailto://drodrigu@dc.uba.ar
*
*  DATE: 03/07/1999
*
*******************************************************************/

#ifndef __EVAL_PARAMS_H
#define __EVAL_PARAMS_H

/** definitions **/
#include <ostream>
#include <stdlib.h>
using namespace std;

class clsEvalParam
{
public:
	clsEvalParam()				//Default constructor
		:evalParamOut(NULL)
		,evalParamActive(false)
		{}

	ostream &Stream()
			{return *evalParamOut;}
			
	void Stream( ostream *evalParamStr )
			{ evalParamOut = evalParamStr; }

	const bool Active()
			{return evalParamActive;}
			
	void Active( bool mode )
			{ evalParamActive = mode; }

	double Value( void )
			{ return value; }
			
	void Value( double valor )
			{ value = valor; }
protected:
	// ** Instance variables ** //
	ostream *evalParamOut ;
	bool evalParamActive ;
	double value ;

};	// class EvalParam




extern clsEvalParam	*evalDebugInstance;
extern clsEvalParam	*flatDebugInstance;
extern clsEvalParam	*rulesDebugInstance;
extern clsEvalParam	*parserDebugInstance;
extern clsEvalParam	*showVirtualTimeDebugInstance;
extern clsEvalParam	*useQuantumInstance;



inline clsEvalParam &ShowVirtualTimeWhenFinish()
{
	if (showVirtualTimeDebugInstance == NULL)
		showVirtualTimeDebugInstance = new clsEvalParam;
	
	return *showVirtualTimeDebugInstance;
}	

inline clsEvalParam &EvalDebug()
{
	if (evalDebugInstance == NULL)
		evalDebugInstance = new clsEvalParam;
	
	return *evalDebugInstance;
}	

inline clsEvalParam &FlatDebug()
{
	if (flatDebugInstance == NULL)
		flatDebugInstance = new clsEvalParam;
	
	return *flatDebugInstance;
}	

inline clsEvalParam &DebugCellRules()
{
	if (rulesDebugInstance == NULL)
		rulesDebugInstance = new clsEvalParam;
	
	return *rulesDebugInstance;
}	

inline clsEvalParam &ParserDebug()
{
	if (parserDebugInstance == NULL)
		parserDebugInstance = new clsEvalParam;
	
	return *parserDebugInstance;
}	

inline clsEvalParam &UseQuantum()
{
	if (useQuantumInstance == NULL)
		useQuantumInstance = new clsEvalParam;
	
	return *useQuantumInstance;
}	

#endif   //__EVAL_PARAMS_H 
