/********************************************************
*	DESCRIPTION	: Log
* 
*	AUTHOR		: Misagh Tavanpour, Jan Mikhail
*	Email		: 
*	DATE		: 30-09-2013
* 
*
********************************************************/

#ifndef LOG_H
#define LOG_H

#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <iostream>
#include <fstream>
#include <sstream>
#include "time.h"
#include "mainsimu.h"
#include "LogManager.h"

using namespace std;

class Log {
	public: 				
		~Log();
		static Log& instance()
		{
			static Log INSTANCE;
			return INSTANCE;
		}		
		void log(const Time msgTime, std::string src, int srcID, std::string des, int desID, std::string owner, int ownerID, std::string msgType, int index, int msgSize, double dataRate, double rcvPower, float delay, double distance, double speed);
		void logAverage(std::string src, int id, int fileSize, int pieceSize, int pieceCount, int avgMsgSize, double avgDataRate, double avgRcvPower, float avgDelay, double avgDistance, double avgSpeed, int numBS);
		void logUploadComplete(std::string text);
		void logTime(std::string src, int id, double uploadRequestTime, double firstPieceSendTime, double lastPieceSendTime, double rcvDoneBitFieldTime, double dataUploadTime, double totalUploadTime);

	private:
		Log();
};

#endif  //_LOG_H

