/********************************************************
*	DESCRIPTION	: Atomic model Network statistics 
* 
*	AUTHOR		: Mohammad Moallemi
*	Email		: moallemi@sce.carleton.ca
*	DATE		: 27-08-2012
* 
*
********************************************************/


#ifndef NETSTATS_H
#define NETSTATS_H

//****    file includes    *********/
#include <fstream>
#include <sstream>
#include "atomic.h"



class NetStats: public Atomic 
{

public: 
	
	
	NetStats(const string &name = "NetStats");
	~NetStats();
	
	virtual string className() const
		{return "NetStats";}
		
protected:
	Model &initFunction();
	
	Model &externalFunction( const ExternalMessage & );
	
	Model &internalFunction( const InternalMessage & );
	
	Model &outputFunction( const InternalMessage &);
	
private:
	void plotUEs();
	void plotBSs();
	void recordDistvsPloss();//record distance vs pathloss for each UE
	void recordDistRxpwr();//record distance vs received power for each UE
	void recordRxpwrPloss();//record received power vs pathloss for each UE
	void plotStats();

	int nodes, links;
	Port &lin, &nin, &bsin;
	Port &ueidout, &bsidout, &uerxpwrout, &bsrxpwrout, &distanceout, &pathlossout;
	Time calcStatsTime;
	enum State{         //to keep current state of the Compass1
				calcStats,      //initial state
			};
			State state;
	
	ofstream xgLocOut; //XGraph data to plot the Location of BSs and UEs
	string distPlossFileName; //XGraph data File name to plot the distance VS pathloss for each BS-UE Link
	string distRxpwrFileName; //XGraph data File name to plot the distance VS Received power for each BS-UE Link
	string rxpwrPlossFileName; //XGraph data File name to plot the received power VS pathloss for each BS-UE Link
	ostringstream distPloss[1000]; //An array of XGraph data to plot the distance VS pathloss for each BS-UE Link
	ostringstream distRxpwr[1000]; //An array of XGraph data to plot the distance VS Received power for each BS-UE Link
	ostringstream rxpwrPloss[1000]; //An array of XGraph data to plot the received power VS pathloss for each BS-UE Link
		
}; //Class NetStats

#endif  //_NETSTATS_H
