/*******************************************************************
*
*  DESCRIPTION: CLASS StandAloneLoader
*
*  AUTHOR:    Amir Barylko & Jorge Beyoglonian 
*  Version 2: Daniel A. Rodriguez
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/6/1998
*  DATE: 11/4/1999 (v2)
*
*******************************************************************/

#ifndef __STDALOAD_H
#define __STDALOAD_H

/** include files **/
#include "loader.h"
#include "macroexp.h"

/** declarations **/

class StandAloneLoader : public SimLoader
{
public:
	StandAloneLoader(int argc, const char *argv[]);
	~StandAloneLoader();	 //Destructor

protected:
	SimLoader &loadData();
	SimLoader &writeResults();

private:
	string	iniName;
	string	outName;
	string	logName;
	string	evName;
	string	evalDebugName;
	string	flatDebugName;
	string	parserFileName;
	int	preprocessor;	// if is 0 then bypass the preprocessor
};	// class StandAloneLoader

#endif   //__STDALOAD_H 
