/*******************************************************************
*
*  DESCRIPTION: class Root
*
*  AUTHOR:    Amir Barylko & Jorge Beyoglonian 
*  Version 2: Daniel Rodriguez
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/06/1998
*  DATE: 02/03/1999 (v2)
*
*******************************************************************/

#ifndef __ROOT_H
#define __ROOT_H

/** include files **/
#include <list>      //Template list
#include "event.h"         //class event
#include "process.h"       // class Processor
#include "procadm.h"       // ProcessorAdmin::RootId 

/** forward declarations **/
class Coupled ;
class MainSimulator ;
class Port ;
class Time ;

/** declarations **/
typedef list<Event> EventList;

class Root : public Processor
{
public:   
	static Root &Instance();
	Root &initialize();
	Root &simulate();
	Root &stop();
	Root &addExternalEvent( const Time &, const Port &, const Real & ) ;
	Processor &receive( const OutputMessage & );
	Processor &receive( const DoneMessage &);
	Root &stopTime( const Time & ) ;
	const Time &stopTime() const ;
	const EventList &events() const ;

	const string description() const ;

private:
	friend class MainSimulator;
	friend class ProcessorAdmin ;

	Root( const ProcId & = ProcessorAdmin::rootId ) ;	  // Default constructor
	Processor *child ;
	Time timeStop ;
	Time lastChg ;
	EventList externalEvents;

	Coupled &top() ;
	const Coupled &top() const ;

};	// class Root


/** inline **/
inline
const EventList &Root::events() const
{
	return externalEvents ;
}

inline
Root &Root::stopTime( const Time &t )
{
	timeStop = t ;
	return *this ;
}

inline
const Time &Root::stopTime() const
{
	return timeStop ;
}

inline
const string Root::description() const
{
	return "Root" ;
}

#endif   //__ROOT_H 
