/*******************************************************************
*
*  DESCRIPTION: class Time
*
*  AUTHOR: Amir Barylko & Jorge Beyoglonian 
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*
*  DATE: 27/6/1998
*
*******************************************************************/

/** include files **/
#include "cdtime.h"         // base class
#include "stringp.h"      // operator + int
#include <stdlib.h>    //sixuan for abs
#include <iostream>

/** public data **/
const Time Time::Zero ;	  // Zero constant
const Time Time::Inf( 32767, 59, 59, 999 ) ;	// Infinity constant

/*******************************************************************
* Function Name: Time
* Description: copy constructor
********************************************************************/
Time::Time( const Time &t )
: hour( t.hours() )
, min( t.minutes() )
, sec( t.seconds() )
, msec( t.mseconds() )
{}

/*******************************************************************
* Function Name: operator +
********************************************************************/
Time Time::operator +( const Time &t ) const
{
	if ( *this == Time::Inf || t == Time::Inf )
		return Time::Inf;

	Time st( hours() + t.hours(),
		 minutes() + t.minutes(),
		 seconds() + t.seconds(),
		 mseconds() + t.mseconds() );

	//st.normalize();	// It's called by constructor and is not needed
	return st;
}

/*******************************************************************
* Function Name: opeartor -
********************************************************************/
Time Time::operator -( const Time &t ) const
{
	if ( *this == Time::Inf || t == Time::Inf )
		return Time::Inf;

	Time st( hours() - t.hours(),
		 minutes() - t.minutes(),
		 seconds() - t.seconds(),
		 mseconds() - t.mseconds() );

	//st.normalize();	// It's called by constructor and is not needed
	return st; 
}

/*******************************************************************
* Function Name: opeartor ==
********************************************************************/
bool Time::operator ==( const Time &t ) const
{
	return ( hours()    == t.hours()    &&
	 	 minutes()  == t.minutes()  &&
		 seconds()  == t.seconds()  &&
		 mseconds() == t.mseconds() );
}

/*******************************************************************
* Function Name: opeartor =
********************************************************************/
Time &Time::operator =( const Time &t )
{
	hour = t.hours();
	sec = t.seconds();
	min = t.minutes();
	msec = t.mseconds();
	return *this;
}
//HENRY compile fix
bool Time::operator !=( const Time &t ) const
{
  return !((*this) == t);
}

/*******************************************************************
* Function Name: operator <<
********************************************************************/
bool Time::operator <( const Time &t ) const
{
	return( hours() < t.hours()    ||
			  ( hours() == t.hours() &&
				 ( minutes() < t.minutes()  ||
					( minutes() == t.minutes()  &&
					  ( seconds() < t.seconds() ||
						 ( seconds() == t.seconds() &&
							mseconds() < t.mseconds() ) ) ) ) ) ) ;
}
//HENRY compile fix
bool Time::operator >=( const Time &t ) const
{
  return !((*this) < t);
}

//HENRY compile fix
bool Time::operator <=( const Time &t ) const
{
  return (((*this) < t)||((*this) == t));
}

//HENRY compile fix
bool Time::operator >( const Time &t ) const
{
  return !((*this) <= t);
}

/*******************************************************************
* Function Name: asString
********************************************************************/
string Time::asString() const
{
	char buf[100];

	if (*this == Time::Inf)
		sprintf( buf, "..." );
	else
		sprintf( buf, "%02d:%02d:%02d:%03d", hours(), minutes(), seconds(), mseconds() );

	return string( buf );
}

/*******************************************************************
* Function Name: makeFrom
* Description: make from string
********************************************************************/
Time &Time::makeFrom( const string &str )
{
	sscanf( str.c_str(), "%d:%d:%d:%d", &hour, &min, &sec, &msec );
	normalize();
	return *this;
}

/*******************************************************************
* Function Name: makeFrom
* Description: make from miliseconds
********************************************************************/
Time &Time::makeFrom( float milsec )
{
	seconds( static_cast< int >( milsec ) ) ;
	milsec -= seconds() ;
	mseconds( static_cast< int >( milsec * 1000 ) ) ;
	normalize() ;
	return *this ;
}

/*******************************************************************
* Function Name: normalize
********************************************************************/
Time &Time::normalize()
{
	// 0..999 Miliseconds
	adjust( msec, sec , 1000 );
	// 0..59 seconds
	adjust( sec , min , 60   );
	// 0..59 minutes
	adjust( min , hour, 60   );
	return *this ;
}

/*******************************************************************
* Function Name: adjust
********************************************************************/
Time &Time::adjust( int &left, int &right, int maxVal )
{
	if( left >= maxVal )
	{
		right += left / maxVal ;
		left %= maxVal ;
	} else if( left < 0 )
	{
		register int aux = abs( left / maxVal ) + ( left % maxVal == 0 ? 0 : 1 );
		right -= aux ;
		left += maxVal * aux ;
	}
	return *this ;
}
