 /***********************************************
 *
 *  DESCRIPTION: Atomic Model MeNB Processor 1
 *
 *  AUTHOR: Baha Uddin Kazi, Victor Silva
 *
 *  DATE: 15/06/2016
 *
 ***********************************************/

 #ifndef __MENB_H
 #define __MENB_H

 #include "atomic.h"   // class Atomic
 #include "string.h"	  // class String
 #include "mainsimu.h"
 #include <iostream>
 #include "Msg.h"
 #include <fstream>
 #include <vector>
 #include <map>

 class MeNB : public Atomic
 {
   	public:
	    MeNB ( const std::string &name = "MeNB" );  //Default constructor
	    virtual std::string className() const {  return "MeNB" ;}
	    ~MeNB();

		void initializeParameters(long ID, unsigned long px, unsigned long py, long freq, long pwr);

		void setPosition(int x, int y){ this->posx = x; this->posy = y; }
		long getID(){return id;}
		unsigned long getX(){return posx;}
		unsigned long getY(){return posy;}
		long getPower(){return p;}

		void sendOut(Time time, const Value &value, ValueO *valueO); //May not be needed!!!
		void sendReq(Time time, const Value &value, ValueO *valueO);
		void holdInActive(Time time);
		void passivateMeNB();


   	protected:
	    Model &initFunction();
	    Model &externalFunction( const ExternalMessage & );
	    Model &internalFunction( const InternalMessage & );
	    Model &outputFunction( const InternalMessage & );

   	private:
	    const Port &In;
		Port &Out, &Req, &X2out;

	    Time ProcessTime;

		Msg* receivedMsg;
		CTRLCmd* CTRLcommand;
		MeasurementReport* MR;
		HOReq* HOreq;
		HOReq* recHOreq;
		HOReqAck* HOReqAcknowledgement;
		HOReqAck* recHOReqAcknowledgement;
		RRCConnReconf* RRCcmd;

		ValueO *valueO;

		

		
		int maximumPower, maxRecPower;
	
		std::map <int, long> SrcENBids;
		std::map <int, long> SeNBids;
		std::map <int, long> TeNBids;
		std::map <int, bool> MRFlags;
		std::map <int, bool> HOReqFlags;
		std::map <int, bool> HOAckFlags;

		int posx, posy, id, f, p, rID, rFreq, rPow,MRtargedID,MRsourceUEid,HOReqSourceUEid,HOReqSourceIDeNB,HOReqtargedID,HOAcksourceUEid,HOAckSourceIDeNB,HOAcktargedID; 
		bool ctrlCmdFlag;
	
		long servingMeNBID, SourceID, SrcUEid, MyThroughput;
		long RecThroughput, DestID, SourceueID, messageCount, CSImessageCount, ccsID, prevSourceID, SrcGrantUEID;

        enum State{
		    Idle,       //initial state
			SendPack,   //Sending Packet
			RecPack    //Receiving Traffic Packet

		};
		State state;
		
		ofstream logfile;

 };

#endif
