/*******************************************************************
*
*  DESCRIPTION: class NeighborhoodValue
*
*  AUTHOR:    Amir Barylko, Jorge Beyoglonian
*  Version 2: Daniel Rodriguez
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/06/1998
*  DATE: 02/06/1999 (v2)
*
*******************************************************************/

#ifndef __NEIGHBORHOOD_VALUE_H
#define __NEIGHBORHOOD_VALUE_H

/** include files **/
#include <mylist.h>	// oList
#include <except.h>	// class MException
#include <real.h>	// The value of the cell
#include <cellpos.h>	// NeighborPosition
#include <coupcell.h>	// CellPositionList

/** foward declarations **/
class CellState ;

/** declarations **/
class NeighborhoodValue
{
public:
	NeighborhoodValue( CellState &mat, const CellPositionList &neighbors, const CellPosition &center);	// default constructor

	~NeighborhoodValue()		// Destructor
		{ delete sneighborList; }

	// ** Modifiers ** //
	NeighborhoodValue &set( const Real &v );

	// ** Queries ** // 
	bool isValid(CellPosition &cp) const;
			// Returns true if the CellPosition is contained
			// in the neighborhood.

	const Real &get( const NeighborPosition &n )  const ; // throws InvalidNeighborRef

	const Real &get() const
		{ return this->get( NeighborPosition(dim,0) ); }
	
	unsigned dimension() const
		{return dim;}
	
	mList *neighborList()
		{return sneighborList;}

	void print(ostream &os);
	
	CellPosition centralPosition() const
		{ return centralCell; }
	
private:
	mList		*sneighborList;
	CellPosition	centralCell;
	unsigned	dim;

	static Real undef ;

	NeighborhoodValue( const NeighborhoodValue & ) ; // copy constructor

}; // NeighborhoodValue

class IvalidNeighbordRef : public MException
{
public:
	IvalidNeighbordRef(): MException( "Invalid Neighbor reference!" )
	{}
};

#endif // __NEIGHBORHOOD_VALUE_H
