/*******************************************************************
*
*  DESCRIPTION: movement
*
*  AUTHOR:    Victor Silva
*  
*
*  EMAIL: mailto://victorguidasilva@gmail.com
*
*  DATE: 27/5/2016
*
*******************************************************************/

#define _USE_MATH_DEFINES
#include <iostream>
#include <cmath>
#include "Point.h"
#include "movement.h"

using namespace std;


movement::movement(const Point& initialPosition, const Point& finalPosition, double speed):
	initialPosition(initialPosition), finalPosition(finalPosition), speed(speed){}

movement::movement(){}

Point movement::getInitialPosition(void) 
{
	return initialPosition;
}

Point movement::getFinalPosition(void)
{
	return finalPosition;
}
double movement::getSpeed(void)
{
	return speed;// m/s
}

double movement::getTime(void)
{
	return time;
}

void movement::setInitialPosition(Point initialPosition)
{
	this->initialPosition = initialPosition;
}
void movement::setFinalPosition(Point finalPosition)
{
	this->finalPosition = finalPosition;
}

void movement::setSpeed(double speed)
{
	this->speed = speed;//convert 'km/h' and enter 'm/s'
}
void movement::setTime(double time)
{
	this->time = time;
}

double movement::distance(Point point1, Point point2)
{
	cout <<	"point1: "<< "(" << point1.getX() << ", " << point1.getY() << ")" <<
	"point2: "<< "(" << point2.getX() << ", " << point2.getY() << ")" << endl;
	return sqrt(((point1.getX() - point2.getX())*(point1.getX() - point2.getX())) + 
		((point1.getY() - point2.getY())*(point1.getY() - point2.getY())));
}


Point movement::findPosition(double distance, double anglePoints, Point initialPosition)
{
	return Point(initialPosition.getX() + distance * cos((M_PI/180) * anglePoints),
		initialPosition.getY() + distance * sin((M_PI/180) * anglePoints));
}

double movement::findTraveledDistance(double time, double speed)
{
	return time*speed;
}

double movement::findAnglePoints(Point point1, Point point2) 
{
	double angle;
	if ( (nearbyint(point1.getY()) == nearbyint(point2.getY())) ) {
		if ( (nearbyint(point1.getX()) < nearbyint(point2.getX())) ) {
			angle = 0;
		}

		if ( (nearbyint(point1.getX()) > nearbyint(point2.getX())) ) {
			angle = 180;
		}
		
	}
	else if( (nearbyint(point1.getX()) == nearbyint(point2.getX())) ) {
		if ( (nearbyint(point1.getY()) < nearbyint(point2.getY())) ) {
			angle = 90;
		}

		if ( (nearbyint(point1.getY()) > nearbyint(point2.getY())) ) {
			angle = 270;
		}
	}
	else if( (nearbyint(point1.getY()) < nearbyint(point2.getY())) && (nearbyint(point1.getX()) < nearbyint(point2.getX())) ) {
		angle = (180/M_PI)*acos((point2.getX() - point1.getX())/distance(point1, point2));
	}
	else if( (nearbyint(point1.getY()) < nearbyint(point2.getY())) && (nearbyint(point1.getX()) > nearbyint(point2.getX())) ) {
		angle = 180 - ((180/M_PI)*acos((point1.getX() - point2.getX())/distance(point1, point2)));
	}
	else if( (nearbyint(point1.getY()) > nearbyint(point2.getY())) && (nearbyint(point1.getX()) > nearbyint(point2.getX())) ) {
		angle = 180 + ((180/M_PI)*acos((point1.getX() - point2.getX())/distance(point1, point2)));
	}
	else if( (nearbyint(point1.getY()) > nearbyint(point2.getY())) && (nearbyint(point1.getX()) < nearbyint(point2.getX())) ) {
		angle = 360 - ((180/M_PI)*acos((point2.getX() - point1.getX())/distance(point1, point2)));
	}
	return angle;


}


/*int main()
{
	Point point1(100,100);
	Point point2(-100,200);
	double speed = 30.0*(10.0/36.0);
	double time = 40*.001;//((distance(point1, point2))/speed)/10.0;  //40*.001;
	cout << "speed*time: " << speed*time << endl;
	movement mov(point1,point2,speed,time);
	cout << "point1.getX(): " << point1.getX() << endl;
	cout << "point1.getY(): " << point1.getY() << endl;
	cout << "point2.getX(): " << point2.getX() << endl;
	cout << "point2.getY(): " << point2.getY() << endl;
	double d = mov.distance(point1, point2);
	cout << "d: " << d << endl;
	double traveledD = mov.findTraveledDistance(time, speed);
	cout << "findTraveledDistance(time, speed): " << traveledD << endl;
	double angle = mov.findAnglePoints(point1, point2);
	cout << "findAnglePoints(point1, point2): " << angle << endl;
	Point point3(Point(mov.findPosition(traveledD, angle, point1)));
	cout << "findPosition(double distance, double anglePoints, Point initialPosition): " << "(" << point3.getX() << "," << point3.getY() << ")" << endl;



	
	return 0;
}*/




