#ifndef MAFILEGEN_H
#define MAFILEGEN_H

#define _USE_MATH_DEFINES
#include <string>
#include <iostream>
#include <vector>
#include <cmath>
#include <stdlib.h>     /* srand, rand */
#include <time.h>       /* time */
#include "Point.h"
#include "polarPoint.h"
#include "PeNB.h"
#include "MeNB.h"
#include "UE.h"

using namespace std;

class maFileGen
{
	public:
		maFileGen(string fileName, string fileName_HomNet, int freq, int BSpow, int RRHpow, int NuUE, int NuBS, int NuRRH, vector<UE> UEs, vector<PeNB> RRHs, vector<MeNB> BSs);
				
		void printBSs(void);
		void printRRHs(void);
		void printUEs(void);
		void generateBSLinks(void);
		void generateRRHLinks(void);
		void generateUELinks(void);
		//Point BSnRRHCommonAreas(MeNB bs);
		//vector<polarPoint> BSnBSCommonAreas(vector<MeNB>& BSs, MeNB& bs);
		int getNuBS(void);
		int getNuRRH(void);
		int getNuUE(void);
		string getFileName(void);
		vector<UE> UEs;
		vector<PeNB> RRHs;
		vector<MeNB> BSs;

	private:
		
		string fileName;
		string fileName_HomNet;
		int freq;
		int BSpow; 
		int RRHpow;
		int NuUE; 
		int NuUEStart;
		int NuBS; 
		int NuRRH;
		
		
				
};
#endif // MAFILEGEN_H
