/*******************************************************************
*
*  DESCRIPTION: class Transducer
*               The transducer calculates statistical information 
*               analizing the processing time.  
*
*  AUTHOR: Amir Barylko & Jorge Beyoglonian 
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*
*  DATE: 27/6/1998
*
*******************************************************************/

#ifndef __TRANSDUCER_H
#define __TRANSDUCER_H

#include <map>
#include "atomic.h"
#include "message.h"

class Transducer: public Atomic
{
public:
	Transducer( const string &name = "Transducer" ) ;	//Default constructor

	virtual string className() const ;

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	typedef map< int, Time, less<int> > JobsList ;

	const Port &arrived ;
	const Port &solved ;

	Port &throughput ;
	Port &cpuUsage ;   

	Time frec ;
	Time tUnit ;
	long procCount ;
	long cpuLoad ;

	JobsList unsolved ; 

	const Time &frecuence() const ;
	const Time &timeUnit() const ;

};	// class Transducer

// ** inline ** // 
inline
string Transducer::className() const
{
	return "Transducer" ;
}

inline
const Time &Transducer::frecuence() const
{
	return frec ;
}


inline
const Time &Transducer::timeUnit() const
{
	return tUnit ;
}

#endif   //__TRANSDUCER_H 
