/*******************************************************************
*
*  DESCRIPTION: class Coupled
*
*  AUTHOR:    Amir Barylko & Jorge Beyoglonian 
*  Version 2: Daniel Rodriguez
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/6/1998
*  DATE: 27/2/1999 (v2)
*
*******************************************************************/

#ifndef __COUPLED_H
#define __COUPLED_H

/** include files **/
#include <list>    // Template list
#include "model.h"    // Base class Model

/** foward declarations **/
class SingleModelAdmin;
class MainSimulator ;

#define	COUPLED_NAME	"Coupled"

/** definitions **/
class Coupled : public Model 
{
public:
	Model &addModel( Model & );

	typedef list<ModelId> ModelList;

	const ModelList &children() const
			{return childs;}

	enum Type
	{
		cell,
		regular
	} ;

	virtual Type type() const
			{return regular;}
	
	virtual string className() const
			{return COUPLED_NAME;}

protected:
	friend class SingleModelAdmin ;
	friend class ModelAdmin ;
	friend class MainSimulator ;

	Coupled( const string &name = "Coupled" )	// Default constructor
			: Model( name )
			{}

	Coupled( const Coupled & )  ;		 // Copy constructor

	virtual Model &addInfluence( const string &sourceName, const string &sourcePort, const string &destName, const string &destPort) ;

private:
	ModelList childs ;

} ; // class Coupled


#endif   //__COUPLED_H 
