%Hatton Cross Roundabout
%December 20, 2012
%Peter Miebach 100616681
%Pradeep Gunaratnam 100322776


%Checklist:
%COMPLETE -> convert assignment 2 roundabout rules to new CD++ version.
%COMPLETE -> fix assignment 2 issues (disappearing cars, car not following 
%roundabout rules) and test.
%COMPLETE -> add logic for car speed so that car will not enter roundabout if
%car coming (2 cells away) is going too fast and test.
%COMPLETE -> add logic for 'number of hops left' so that car entering mini-
%roundabout (numofhopsleft=0) is directed to exit and test.
%COMPLETE -> add logic for 'number of hops left' so that car leaving mini-
%roundabout to another mini roundabout decrements 'numofhopsleft' by 1 and test.
%COMPLETE -> connect mini-roundabout to DEVS input queue and test.

%PLANNED -> connect mini-roundabouts to each other.



[top]
components : roundabout 
components : queue@Queue 

in : in done stop

Link : in in@queue
%Link : out@queue inAutoS@roundabout
Link : done done@queue


[queue]
preparation : 00:00:00:000







[roundabout]
type : cell
width : 8
height : 6
delay : transport
defaultDelayTime : 100
border : nonwrapped 
%local neighbors (increased to 2 for speedport):
neighbors : roundabout(-2,-2) roundabout(-2,-1) roundabout(-2,0) roundabout(-2,1) roundabout(-2,2) 
neighbors : roundabout(-1,-2) roundabout(-1,-1) roundabout(-1,0) roundabout(-1,1) roundabout(-1,2)
neighbors : roundabout(0,-2)  roundabout(0,-1)  roundabout(0,0)  roundabout(0,1)  roundabout(0,2)
neighbors : roundabout(1,-2)  roundabout(1,-1)  roundabout(1,0)  roundabout(1,1)  roundabout(1,2)
neighbors : roundabout(2,-2)  roundabout(2,-1)  roundabout(2,0)  roundabout(2,1)  roundabout(2,2)
initialvalue : 0
initialrowvalue :  0     00000000
initialrowvalue :  1     01181990
initialrowvalue :  2     07800810
initialrowvalue :  3     00911700
initialrowvalue :  4     00018000
initialrowvalue :  5     00000000
localtransition : roundabout-rule

statevariables: direction isexit initDone testinitDone
%direction:    North = 1, East = 2, South = 3, West = 4
%isexit:       specify if the cell is an exit and which one (West Exit = 7, South Exit = 8, East Exit = 9, not an exit = 0)
%initDone:     To initialize each cell to make sure all cells are outputing their direction
%testinitDone: For testing purposes only (insert cars into model to test roundabout and connector logic)
statevalues:   0 0 0 0
initialvariablesvalue: roundabout.stvalues

neighborports : exitnumberport numhopsleftport speedport directionport isexitport
%exitnumberport:   If car is present in cell, indicates what exit it will leave at. (West Exit = 7, South Exit = 8, East Exit = 9, empty road = 1)
%numhopsleftport:  number of roundabouts car must pass through before leaving Hattoncross
%speedport:        speed of car travelling through roundabout
%directionport:    output cell's direction to neighbour cells
%isexitport:       indicate to neighbour cells what exit I am or if I'm not an exit.
%DrawLog Note: Make sure port variables are in lower case otherwise DrawLog does not work!

%For car queue into Hattoncross roundabout:
in : inAutoS
link : inAutoS inAutoS@roundabout(4,4)
portInTransition : inAutoS@roundabout(4,4) special-rule



[special-rule]
rule :  { ~exitnumberport := 7;
		  ~numhopsleftport := (trunc((portValue(thisPort) - 700) / 10));
		  ~speedport := ((fractional((portValue(thisPort) - 700) / 10)) * 10); }
		100 
		{trunc(portValue(thisPort) / 100) = 7}
rule :  { ~exitnumberport := 8;
		  ~numhopsleftport := (trunc((portValue(thisPort) - 800) / 10));
		  ~speedport := ((fractional((portValue(thisPort) - 800) / 10)) * 10); }
		100 
		{trunc(portValue(thisPort) / 100) = 8}
rule :  { ~exitnumberport := 9;
		  ~numhopsleftport := (trunc((portValue(thisPort) - 900) / 10));
		  ~speedport := ((fractional((portValue(thisPort) - 900) / 10)) * 10); }
		100 
		{trunc(portValue(thisPort) / 100) = 9}
rule : { (0,0) } 0 { t }






[roundabout-rule]
%/////////////////////////////INITIALIZATION///////////////////////////
%initialization of cells (to be run only once by each cell)
rule : { ~directionport := $direction; 
		 ~isexitport := $isexit;
		 ~exitnumberport := (0,0)~exitnumberport;
		 ~numhopsleftport := 0;} 
       { $initDone:=1;} 
	   100 
	   { $direction > 0 and
         $initDone =0 }
%///////////////////////END OF INITIALIZATION/////////////////////////
		 

		 
		 
		 
		 
		 
		 
		 

%///////////////////////////////TESTING//////////////////////////////
%Testing allows the user to input cars into the system with desired variables






		 
%test numhopsleftport for car entering mini roundabout (can just test one at a time)
%(2,1)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 0;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (-1,0)~isexitport = 7 and
%         $testinitDone =0}
%(4,4)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 0;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,-1)~isexitport = 8 and
%         $testinitDone =0}
%(1,6)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 0;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (1,0)~isexitport = 9 and
%         $testinitDone =0}
	   
%test numhopsleftport for car leaving mini roundabout to another mini roundabout (can just test one at a time)
%(3,3) -> dont need to test since car leaves Hatton Cross system
%(1,2)
%rule : { ~exitnumberport := 7;
%         ~numhopsleftport := 4;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,-1)~isexitport = 7 and
%         $testinitDone =0}
%(2,5)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 4;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,1)~isexitport = 9 and
%         $testinitDone =0}	   
	   
%test speedport (test one set(2 cells) at a time):
%(2,1)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 1;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (-1,0)~isexitport = 7 and
%         $testinitDone =0}
%(1,3)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 1;
%		 ~speedport := 2;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,-2)~isexitport = 7 and
%         $testinitDone =0}

%(4,4)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 1;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,-1)~isexitport = 8 and
%         $testinitDone =0}
%(3,2)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 1;
%		 ~speedport := 2;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (1,1)~isexitport = 8 and
%         $testinitDone =0}

%(1,6)
%rule : { ~exitnumberport := 7;
%         ~numhopsleftport := 1;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (1,0)~isexitport = 9 and
%         $testinitDone =0}
%(3,5)
%rule : { ~exitnumberport := 7;
%         ~numhopsleftport := 1;
%		 ~speedport := 2;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (-1,1)~isexitport = 9 and
%         $testinitDone =0}		 
%///////////////////////////END OF TESTING///////////////////////////
	   
	   
	   

%///////////////////////////////RULES///////////////////////////////


%%%%%%%%%%%%%%%%%%%cars going into cells:
%(2,2)
%%car in loop gets priority (ignore car 7 since it leaves at 7):
rule : { ~exitnumberport := (-1,0)~exitnumberport;
         ~numhopsleftport := (-1,0)~numhopsleftport; 
		 ~speedport := (-1,0)~speedport;
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       { } 
	   100 
	   { (0,0)~exitnumberport = 1 and 
	   (-1,0)~exitnumberport > 1 and 
	   (-1,0)~exitnumberport != 7 and 
	   (-1,0)~directionport = 3 and 
	   (-1,-1)~isexitport = 7 and
	   $direction =3 and 
	   $isexit =0 }
%check if car that is entering is leaving the overall roundabout system
%if so then change exit # to '8'
%also check if car two cells away is speeding
rule : { ~exitnumberport := 8;
         ~numhopsleftport := 0; 
		 ~speedport := (0,-1)~speedport;		 
	    ~directionport := $direction; 
	    ~isexitport := $isexit;}		
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport > 1 and 
        (0,-1)~directionport = 2 and
		(0,-1)~numhopsleftport = 0 and
		(-1,1)~speedport != 2 and
        $direction =3 and
		(-1,-1)~isexitport = 7 and
        $isexit =0 }	   
rule : { ~exitnumberport := (0,-1)~exitnumberport;
         ~numhopsleftport := (0,-1)~numhopsleftport;
		 ~speedport := (0,-1)~speedport;		 
	    ~directionport := $direction; 
	    ~isexitport := $isexit;}		
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport > 1 and 
        (0,-1)~directionport = 2 and
		(-1,1)~speedport != 2 and
        $direction =3 and
		(-1,-1)~isexitport = 7 and
        $isexit =0 }

%(3,2)
rule : {~exitnumberport := (-1,0)~exitnumberport; 
         ~numhopsleftport := (-1,0)~numhopsleftport;
		 ~speedport := (-1,0)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (-1,0)~exitnumberport > 1 and 
        (-1,0)~directionport = 3 and
        $direction =2 and
		(1,1)~isexitport = 8 and
        $isexit =0 }


%(3,3)
rule : {~exitnumberport := (0,-1)~exitnumberport; 
         ~numhopsleftport := (0,-1)~numhopsleftport;
		 ~speedport := (0,-1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport > 1 and 
        (0,-1)~directionport = 2 and
        (1,0)~isexitport = 8 and
		$direction =2 and
        $isexit =0 }

%(3,4)
%%car in loop gets priority (ignore car 8 since it leaves at 8):
rule : {~exitnumberport := (0,-1)~exitnumberport; 
         ~numhopsleftport := (0,-1)~numhopsleftport;
		 ~speedport := (0,-1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and
        (0,-1)~exitnumberport > 1 and
        (0,-1)~exitnumberport != 8 and
        (0,-1)~directionport = 2 and
		(1,-1)~isexitport = 8 and
        $direction =2 and
        $isexit =0}
%check if car is leaving the overall roundabout system
%if so then change exit # to '8'
%also check if car two cells away is speeding
rule : {~exitnumberport := 8;
         ~numhopsleftport := 0;
		 ~speedport := (1,0)~speedport;	 
	   ~directionport := $direction;
	   ~isexitport := $isexit;}
       {}
       100
       { (0,0)~exitnumberport = 1 and
        (1,0)~exitnumberport > 1 and
		(1,0)~numhopsleftport = 0 and
		(0,-2)~speedport != 2 and
		(1,-1)~isexitport = 8}
rule : {~exitnumberport := (1,0)~exitnumberport;
         ~numhopsleftport := (1,0)~numhopsleftport;
		 ~speedport := (1,0)~speedport;	 
	   ~directionport := $direction;
	   ~isexitport := $isexit;}
       {}
       100
       { (0,0)~exitnumberport = 1 and
         (1,0)~exitnumberport > 1 and
		 (0,-2)~speedport != 2 and
         (1,-1)~isexitport = 8}
		


%(3,5)        
rule : {~exitnumberport := (0,-1)~exitnumberport; 
         ~numhopsleftport := (0,-1)~numhopsleftport; 
		 ~speedport := (0,-1)~speedport;
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport > 1 and 
        (0,-1)~directionport = 2 and
		(-1,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0}

%(2,5)    
rule: {~exitnumberport := (1,0)~exitnumberport; 
         ~numhopsleftport := (1,0)~numhopsleftport;
		 ~speedport := (1,0)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
      { }
      100 
      { (0,0)~exitnumberport = 1 and 
        (1,0)~exitnumberport > 1 and 
        (1,0)~directionport = 1 and
		(0,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0}

%(1,5)
%%car in loop gets priority (ignore car 9 since it leaves at 9):
rule : {~exitnumberport := (1,0)~exitnumberport; 
         ~numhopsleftport := (1,0)~numhopsleftport;
		 ~speedport := (1,0)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (1,0)~exitnumberport > 1 and 
        (1,0)~exitnumberport != 9 and
        (1,0)~directionport = 1 and
		(1,1)~isexitport = 9 and
        $direction = 4 and
        $isexit = 0 }
		
%check if car is leaving the overall roundabout system
%if so then change exit # to '8'
%also check if car two cells away is speeding
rule : {~exitnumberport := 8;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       {}
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(0,1)~numhopsleftport = 0 and
		(2,0)~speedport != 2 and
		(1,1)~isexitport = 9 and
        $direction =4 and
        $isexit =0 }		
rule : {~exitnumberport := (0,1)~exitnumberport;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       {}
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(2,0)~speedport != 2 and
		(1,1)~isexitport = 9 and
        $direction =4 and
        $isexit =0 }
 
%(1,4)
rule : {~exitnumberport := (0,1)~exitnumberport;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(1,1)~exitnumberport > 0 and
		(1,2)~isexitport = 9 and
        $direction =4 and
        $isexit =0 }

%(1,3)
rule : {~exitnumberport := (0,1)~exitnumberport;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(1,-1)~exitnumberport > 0 and
        $direction =4 and
		(0,-2)~isexitport = 7 and
        $isexit =0 }
        
%(1,2)
rule : {~exitnumberport := (0,1)~exitnumberport;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(0,-1)~isexitport = 7 and
        $direction =3 and
        $isexit =0 }
		
%%%%%%%%%%%%%car going into exit cell
%if car is going to another mini-roundabout, decrement numofhopsleft by 1
%(1,1) car going to left mini-roundabout
rule : {~numhopsleftport := (0,1)~numhopsleftport - 1; 
		~exitnumberport := (0,1)~exitnumberport;
		~speedport := (0,1)~speedport; 
		~directionport := $direction;
		~isexitport := $isexit;} 
		100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport = 7 and 
        (0,1)~directionport = 3 and
		(0,0)~isexitport = 7 and
        $direction =4 and
        $isexit =7 }
		

%(4,3) car leaving Hattoncross roundabout system
rule : {~exitnumberport := (-1,0)~exitnumberport;
         ~numhopsleftport := (-1,0)~numhopsleftport;
		 ~speedport := (-1,0)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (-1,0)~exitnumberport = 8 and 
        (-1,0)~directionport = 2 and
		(0,0)~isexitport = 8 and
        $direction =3 and
        $isexit =8 }
		
%(2,6) car going to right mini-roundabout
rule : { ~numhopsleftport := (0,-1)~numhopsleftport - 1;
         ~exitnumberport := (0,-1)~exitnumberport;
		 ~speedport := (0,-1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport = 9 and 
        (0,-1)~directionport = 1 and
		(0,0)~isexitport = 9 and
        $direction =2 and
        $isexit =9 }


		
%%%%%%%%%%%%%%%%%%%cars leaving cells:		

%clear cells in roundabout

%(2,2)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
	   { (0,0)~exitnumberport > 1 and 
	   (1,0)~exitnumberport = 1 and 
	   (1,0)~directionport = 2 and 
	   (-1,-1)~isexitport = 7 and
	   $direction =3 and 
	   $isexit =0 }
	   
%(3,2)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,1)~exitnumberport = 1 and 
        (0,1)~directionport = 2 and
		(1,1)~isexitport = 8 and
        $direction =2 and
        $isexit =0 }
		
%(3,3)
%%first check if car left at exit
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0; 
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport = 8 and 
        (1,0)~exitnumberport = 1 and 
        (1,0)~directionport = 3 and
		(1,0)~isexitport = 8 and
        $direction =2 and
        $isexit =0 }
		
rule : {~exitnumberport := 1;
         ~numhopsleftport := 0;  
		 		 ~speedport := 0;
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and
         (0,0)~exitnumberport != 8 and	   
        (0,1)~exitnumberport = 1 and 
        (0,1)~directionport = 2 and
		(1,0)~isexitport = 8 and
        $direction =2 and
        $isexit =0 }

%(3,4)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;  
		 		 ~speedport := 0;
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,1)~exitnumberport = 1 and 
        (0,1)~directionport = 1 and
		(1,-1)~isexitport = 8 and
        $direction =2 and
        $isexit =0 }

		
%(3,5)
rule : {~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
        (-1,0)~exitnumberport = 1 and 
        (-1,0)~directionport = 1 and
		(-1,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0 }		

%(2,5)
%%first check if car left at exit
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport = 9 and 
        (0,1)~exitnumberport = 1 and 
        (0,1)~directionport = 2 and
		(0,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0 }
rule : {~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
	     (0,0)~exitnumberport != 9 and
        (-1,0)~exitnumberport = 1 and 
        (-1,0)~directionport = 4 and
		(0,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0 }	

%(1,5)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0; 
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,-1)~exitnumberport = 1 and 
        (0,-1)~directionport = 4 and
		(1,1)~isexitport = 9 and
        $direction =4 and
        $isexit =0}

%(1,4)
rule : { ~exitnumberport := 1; 
         ~numhopsleftport := 0; 
		 		 ~speedport := 0;
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,-1)~exitnumberport = 1 and 
        (0,-1)~directionport = 4 and
		(0,1)~directionport = 4 and
        $direction =4 and
        $isexit =0 }		
		
%(1,3)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,-1)~exitnumberport = 1 and 
        (0,-1)~directionport = 3 and
		(0,1)~directionport = 4 and
        $direction =4 and
        $isexit =0 }

%(1,2)
%%first check if car left at exit
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport = 7 and 
        (0,-1)~exitnumberport = 1 and 
        (0,-1)~directionport = 4 and
		(0,-1)~isexitport = 7 and
        $direction =3 and
        $isexit =0 }
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
	     (0,0)~exitnumberport != 7 and 
        (1,0)~exitnumberport = 1 and 
        (1,0)~directionport = 3 and
		(0,-1)~isexitport = 7 and
        $direction =3 and
        $isexit =0 }


%clear entrance cells:	


%(2,1)
%car didnt move if car 2 cells away was speeding
rule : {~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
        (0,1)~exitnumberport = 1 and 
        ( (-1,1)~exitnumberport = 1 or (-1,1)~exitnumberport = 7 ) and 
        (0,1)~directionport = 3 and
		(-1,2)~speedport != 2 and
		(-1,0)~isexitport = 7 and
        $direction =2 and
        $isexit =0 }
	
%(4,4)
%car didnt move if car 2 cells away was speeding
rule : {~exitnumberport := 1; 
         ~numhopsleftport := 0; 
		 		 ~speedport := 0;
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
	   ( (-1,-1)~exitnumberport = 1 or (-1,-1)~exitnumberport = 8 ) and
        (-1,0)~exitnumberport = 1 and
		(-1,-2)~speedport != 2 and
		(0,-1)~isexitport = 8}

%(1,6)		
%car didnt move if car 2 cells away was speeding
rule : {~exitnumberport := 1; 
         ~numhopsleftport := 0; 
		 		 ~speedport := 0;
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
        (0,-1)~exitnumberport = 1 and 
        ( (1,-1)~exitnumberport = 1 or (1,-1)~exitnumberport = 9 ) and  
        (0,-1)~directionport = 4 and
		(2,-1)~speedport != 2 and
		(1,0)~isexitport = 9 and
        $direction =4 and
        $isexit =0 }		


%%%%%%%%%clear exit cells:
%(1,1)
rule : { ~exitnumberport := 1; 
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        $isexit =7 }		

%(4,3)
rule : { ~exitnumberport := 1; 
         ~numhopsleftport := 0; 
		 		 ~speedport := 0;
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        $isexit =8 }
		
%(2,6)
rule : { ~exitnumberport := 1; 
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        $isexit =9 }		
	
		
		
rule : { (0,0) } 100 { t }
%////////////////////////////END OF RULES///////////////////////////