/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.internal;

import com.noelios.restlet.Engine;
import java.net.URL;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.restlet.Client;
import org.restlet.Server;

public class Activator
implements BundleActivator {
    private void registerHelper(Bundle bundle, List helpers, Class constructorClass, String descriptorPath) {
        URL configUrl = bundle.getEntry(descriptorPath);
        if (configUrl == null) {
            configUrl = bundle.getEntry("/src/" + descriptorPath);
        }
        if (configUrl != null) {
            this.registerHelper(bundle, helpers, constructorClass, configUrl);
        }
    }

    private void registerHelper(final Bundle bundle, List helpers, Class constructorClass, URL descriptorUrl) {
        Engine.getInstance().registerHelper(new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return bundle.loadClass(name);
            }
        }, descriptorUrl, helpers, constructorClass);
    }

    private void registerHelpers(Bundle bundle) {
        this.registerHelper(bundle, Engine.getInstance().getRegisteredServers(), Server.class, "META-INF/services/com.noelios.restlet.ServerHelper");
        this.registerHelper(bundle, Engine.getInstance().getRegisteredClients(), Client.class, "META-INF/services/com.noelios.restlet.ClientHelper");
        this.registerHelper(bundle, Engine.getInstance().getRegisteredAuthentications(), null, "META-INF/services/com.noelios.restlet.AuthenticationHelper");
    }

    public void start(BundleContext context) throws Exception {
        org.restlet.util.Engine.setInstance(new Engine(false));
        for (Bundle bundle : context.getBundles()) {
            this.registerHelpers(bundle);
        }
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                switch (event.getType()) {
                    case 1: {
                        Activator.this.registerHelpers(event.getBundle());
                        break;
                    }
                }
            }
        });
        Engine.getInstance().registerDefaultConnectors();
        Engine.getInstance().registerDefaultAuthentications();
    }

    public void stop(BundleContext context) throws Exception {
        org.restlet.util.Engine.setInstance(null);
    }
}

