/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.net;

import com.noelios.restlet.Engine;
import com.noelios.restlet.ext.net.HttpClientHelper;
import com.noelios.restlet.http.HttpClientCall;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.restlet.data.Parameter;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.util.Series;
import org.restlet.util.WrapperRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUrlConnectionCall
extends HttpClientCall {
    private final HttpURLConnection connection;
    private volatile boolean responseHeadersAdded;

    public HttpUrlConnectionCall(HttpClientHelper helper, String method, String requestUri, boolean hasEntity) throws IOException {
        super((com.noelios.restlet.http.HttpClientHelper)helper, method, requestUri);
        if (requestUri.startsWith("http")) {
            URL url = new URL(requestUri);
            this.connection = (HttpURLConnection)url.openConnection();
            int majorVersionNumber = Engine.getJavaMajorVersion();
            int minorVersionNumber = Engine.getJavaMinorVersion();
            if (majorVersionNumber > 1 || majorVersionNumber == 1 && minorVersionNumber >= 5) {
                this.connection.setConnectTimeout(this.getHelper().getConnectTimeout());
                this.connection.setReadTimeout(this.getHelper().getReadTimeout());
            }
            this.connection.setAllowUserInteraction(this.getHelper().isAllowUserInteraction());
            this.connection.setDoOutput(hasEntity);
            this.connection.setInstanceFollowRedirects(this.getHelper().isFollowRedirects());
            this.connection.setUseCaches(this.getHelper().isUseCaches());
            this.responseHeadersAdded = false;
            if (this.connection instanceof HttpsURLConnection) {
                this.setConfidential(true);
                HostnameVerifier verifier = helper.getHostnameVerifier();
                if (verifier != null) {
                    HttpsURLConnection https = (HttpsURLConnection)this.connection;
                    https.setHostnameVerifier(verifier);
                }
            }
        } else {
            throw new IllegalArgumentException("Only HTTP or HTTPS resource URIs are allowed here");
        }
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public HttpClientHelper getHelper() {
        return (HttpClientHelper)super.getHelper();
    }

    public String getReasonPhrase() {
        try {
            return this.getConnection().getResponseMessage();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected Representation getRepresentation(InputStream stream) {
        Representation r = super.getRepresentation(stream);
        return new ConnectionClosingRepresentation(r, this.getConnection());
    }

    public WritableByteChannel getRequestEntityChannel() {
        return null;
    }

    public OutputStream getRequestEntityStream() {
        return this.getRequestStream();
    }

    public OutputStream getRequestHeadStream() {
        return this.getRequestStream();
    }

    public OutputStream getRequestStream() {
        try {
            return this.getConnection().getOutputStream();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public ReadableByteChannel getResponseEntityChannel(long size) {
        return null;
    }

    public InputStream getResponseEntityStream(long size) {
        InputStream result = null;
        try {
            result = this.getConnection().getInputStream();
        }
        catch (IOException ioe) {
            result = this.getConnection().getErrorStream();
        }
        if (result == null) {
            result = this.getConnection().getErrorStream();
        }
        return result;
    }

    public Series<Parameter> getResponseHeaders() {
        Series result = super.getResponseHeaders();
        if (!this.responseHeadersAdded) {
            int i = 1;
            String headerName = this.getConnection().getHeaderFieldKey(i);
            String headerValue = this.getConnection().getHeaderField(i);
            while (headerName != null) {
                result.add(headerName, headerValue);
                headerName = this.getConnection().getHeaderFieldKey(++i);
                headerValue = this.getConnection().getHeaderField(i);
            }
            this.responseHeadersAdded = true;
        }
        return result;
    }

    public String getServerAddress() {
        return this.getConnection().getURL().getHost();
    }

    public int getStatusCode() throws IOException {
        return this.getConnection().getResponseCode();
    }

    public Status sendRequest(Request request) {
        Status result = null;
        try {
            if (request.isEntityAvailable()) {
                Representation entity = request.getEntity();
                int majorVersionNumber = Engine.getJavaMajorVersion();
                int minorVersionNumber = Engine.getJavaMinorVersion();
                if (majorVersionNumber > 1 || majorVersionNumber == 1 && minorVersionNumber >= 5) {
                    if (entity.getSize() != -1L) {
                        this.getConnection().setFixedLengthStreamingMode((int)entity.getSize());
                    } else if (this.getHelper().getChunkLength() >= 0) {
                        this.getConnection().setChunkedStreamingMode(this.getHelper().getChunkLength());
                    }
                }
            }
            this.getConnection().setRequestMethod(this.getMethod());
            for (Parameter header : this.getRequestHeaders()) {
                this.getConnection().addRequestProperty(header.getName(), header.getValue());
            }
            this.getConnection().connect();
            result = super.sendRequest(request);
        }
        catch (ConnectException ce) {
            this.getHelper().getLogger().log(Level.FINE, "An error occurred during the connection to the remote HTTP server.", ce);
            result = new Status(Status.CONNECTOR_ERROR_CONNECTION, (Throwable)ce);
        }
        catch (SocketTimeoutException ste) {
            this.getHelper().getLogger().log(Level.FINE, "An timeout error occurred during the communication with the remote HTTP server.", ste);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ste);
        }
        catch (FileNotFoundException fnfe) {
            this.getHelper().getLogger().log(Level.FINE, "An unexpected error occurred during the sending of the HTTP request.", fnfe);
            result = new Status(Status.CONNECTOR_ERROR_INTERNAL, (Throwable)fnfe);
        }
        catch (IOException ioe) {
            this.getHelper().getLogger().log(Level.FINE, "An error occurred during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ioe);
        }
        catch (Exception e) {
            this.getHelper().getLogger().log(Level.FINE, "An unexpected error occurred during the sending of the HTTP request.", e);
            result = new Status(Status.CONNECTOR_ERROR_INTERNAL, (Throwable)e);
        }
        return result;
    }

    private static class ConnectionClosingRepresentation
    extends WrapperRepresentation {
        private final HttpURLConnection connection;

        public ConnectionClosingRepresentation(Representation wrappedRepresentation, HttpURLConnection connection) {
            super(wrappedRepresentation);
            this.connection = connection;
        }

        public void release() {
            this.connection.disconnect();
            super.release();
        }
    }
}

