 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Mobile Subscriber (MSC)
 *
 *  AUTHOR: Dan Liu
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __MSC_H
 #define __MSC_H

 #include "atomic.h"   // class Atomic
 #include "string.h"	  // class String


#define UPDATE_DEFAULT 0
#define UPDATE_SUCC    1
#define UPDATE_FAIL    2

//define -100 - -1 as instructions contained in message
#define FAIL             -1
#define FORCE_UPDATE     -2
#define FORCE_UPDATE_ACK -3
#define UPDATE_REQ       -4
#define UPDATE_ACK       -5
#define HR_REQ           -6
#define HR_ACK           -7


 class MSC : public Atomic
 {
   public:
	       MSC ( const std::string &name = "MSC" );  //Default constructor
	       virtual std::string className() const {  return "MSC" ;}
	       ~MSC();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        /*
	        const Port &In;
	        Port &Out;
	        */

	          const Port &UpdateReqIn;
	          const Port &HRAckIn;
	          Port &HRReqOut;
	          Port &UpdateAckOut;

	        Time ProcessTime;

	        char camIMSI[100];// store registered imsis

            //unsigned char ucmUpdateResult;//
            //int imIMSI;//

            enum State
            {
              IDLE,
              UPDATE,
              ACK_UPDATE,
              REQ_HR,
            };
            State state;

	        /*
         	int packetNumber;
         	int ackValue;
         	int lastSentPacketAcked;
         	int permissionToSend;
         	enum State{
			            idle,
			            sendPack,
			            rcvAck,
		              };
		    State state;
		    */

 };

#endif   //__MSC_H
